% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphgmfr.R
\name{coxphgmfr}
\alias{coxphgmfr}
\title{Cox PH model with univariate and bivariate shared gamma frailty model.}
\usage{
coxphgmfr(formula, data, initfrailp = NULL, control = bcfraildv.control(), ...)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the \code{Surv} function.}

\item{data}{A dataframe contain survival time, censor, covariate etc with data in columns.}

\item{initfrailp}{Initial estimates for the frailty parameters. The default is c(0.5).}

\item{control}{Arguments to control the fit. The default is \code{\link{bcfraildv.control}}.}

\item{...}{further arguments}
}
\value{
An object of  that contains  the following components.
\itemize{
  \item \code{coefficients} - {A vector of estimated Covariate coefficients.}
  \item \code{frailparest} - {A vector of estimated Frailty parameters i.e. frailty variance and correlation.}
  \item \code{vcov}- {Variance Covariance matrix of the Estimated Covariate coefficients obtained from the observed information matrix.}
  \item \code{vcov2}-Variance Covariance matrix of the Estimated Frailty parameters obtained from the observed information matrix of the mariginal likelihood.
  \item \code{stderr}-{A vector containing the Standard error of the Estimated parameters both covariate coefficients and  frailty parameter.}
  \item \code{loglilk0}- Log likelihood of without frailty model.
  \item \code{loglilk}-Log likelihood of Cox PH model with frailty.
  \item \code{Iloglilk}- Log likelihood of with frailty model after integrating out the frailty term.
  \item \code{cbashaz}- array containing Cummulative baseline hazard.
  \item \code{X}-{Matrix of observed covariates.}
  \item \code{time}-{the observed survival time.}
  \item \code{censor}-{censoring indicator.}
  \item \code{resid}-{the martingale residuals.}
  \item \code{lin.prid}-{the vector of linear predictors.}
  \item \code{frail}-{estimated Frailty values.}
  \item \code{iteration}-{Number of outer iterations.}
  \item \code{e.time}-{the vector of unique event times.}
  \item \code{n.event}- {the number of events at each of the unique event times.}
  \item \code{converg}-  {TRUE if converge, FALSE otherwise.}
  }
}
\description{
Fit Cox PH model with univariate and bivariate shared gamma frailty model.
}
\note{
This is just a \code{\link{coxph}} model with gamma frailty and the differences between
\code{\link{coxph}} with gamma frailty fit and \code{\link{coxphgmfr}} fit is on the standard errors of the
covariates cofficients. Here, the standard errors of the estimated covariate coefficients and the frailty variance parameter are obtained using
the standard errors estimation approach given in Klein and Moeschberger (2003).
}
\examples{
set.seed(2)
n1=600;IID=array(1:n1)
X1<-runif(n1,  min=0, max=1)
z=rgamma(n1,shape=2,scale=0.5)
u1<-runif(n1,  min=0, max=1)
time<- 1/0.1*log(1-0.1*log(u1)/(0.0001*exp(3*X1)*z))
censor=rep(1,n1)
dataa <- data.frame(time=time, X1=X1,censor=censor,IID=IID)

fitcoxfr=coxphgmfr(Surv(time,censor)~ X1+frailty(IID) ,data=dataa)
fitcoxfr

\donttest{
### for SHARED bivariate gamma frailty fit
# simulate data
# 800 pairs,uniform covariate with coefficient 3.
# gamma frailty variable with parameters:variance =0.5 and mean 1
set.seed(3)
n=800; n1=n*2   ### 800 pairs
indic1=2*array(1:n)-1;indic2=2*array(1:n)
PID=1;e1=array(1:n);PID[indic1]=e1;PID[indic2]=e1  ### cluster
X1<-runif(n1,  min=0, max=1)
z=rgamma(n,shape=2,scale=0.5)
Z=1;Z[indic1]=z;Z[indic2]=z
u1<-runif(n1,  min=0, max=1)
time<- 1/0.1*log(1-0.1*log(u1)/(0.0001*exp(3*X1)*Z))
censor=rep(1,n1)
dataa <- data.frame(time=time, X1=X1,censor=censor,PID=PID)

# fit
fitcoxfr=coxphgmfr(Surv(time,censor)~ X1+frailty(PID) ,data=dataa)
fitcoxfr
# Compare with coxph fit
cphfit <- coxph(Surv(time, censor, type = "right") ~ X1+frailty(ID),data =  dataa )
cphfit
# see the differences on the standard errors of the covariate coefficients

# Not run

#if data is not supplied
fitcoxfr=coxphgmfr(Surv(time,censor)~ X1+frailty(PID))
fitcoxfr

#if covariates are not included
fitcoxfr=coxphgmfr(Surv(time,censor)~ 1+frailty(PID) ,data=dataa)
fitcoxfr

# End Not run
}

}
\references{
Duchateau, L., Janssen, P. (2008) The Frailty Model. Springer, New York.

Klein, J. P., and Moeschberger, M. L. (2003), Survival analysis: techniques for censored and truncated data, New York: Springer.
}
\seealso{
\code{\link{bcgfrailev}}
}
