% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-classes.R, R/utils-filter.R
\name{filter.bcdc_promise}
\alias{filter.bcdc_promise}
\alias{filter}
\title{Filter a query from bcdc_query_geodata()}
\usage{
\method{filter}{bcdc_promise}(.data, ...)
}
\arguments{
\item{.data}{object of class \code{bcdc_promise} (likely passed from \code{\link[=bcdc_query_geodata]{bcdc_query_geodata()}})}

\item{...}{Logical predicates with which to filter the results. Multiple
conditions are combined with \code{&}. Only rows where the condition evaluates to
\code{TRUE} are kept. Accepts normal R expressions as well as any of the special
\link[=cql_geom_predicates]{CQL geometry functions} such as \code{WITHIN()} or \code{INTERSECTS()}.
If you know \code{CQL} and want to write a \code{CQL} query directly, write it enclosed
in quotes, wrapped in the \code{\link[=CQL]{CQL()}} function. e.g., \code{CQL("ID = '42'")}.

If your filter expression contains calls that need to be executed locally, wrap them
in \code{local()} to force evaluation in R before the request is sent to the server.}
}
\description{
Filter a query from Web Feature Service using dplyr
methods. This filtering is accomplished lazily so that
the full sf object is not read into memory until
\code{collect()} has been called.

See \code{dplyr::\link[dplyr]{filter}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter(bcdc_promise)}: filter.bcdc_promise

}}
\examples{
\donttest{
try(
  crd <- bcdc_query_geodata("regional-districts-legally-defined-administrative-areas-of-bc") \%>\%
    filter(ADMIN_AREA_NAME == "Cariboo Regional District") \%>\%
    collect()
)

try(
  ret1 <- bcdc_query_geodata("fire-perimeters-historical") \%>\%
    filter(FIRE_YEAR == 2000, FIRE_CAUSE == "Person", INTERSECTS(crd)) \%>\%
    collect()
)

# Use local() to force parts of your call to be evaluated in R:
try({
  # Create a bounding box around two points and use that to filter
  # the remote data set
  library(sf)
  two_points <- st_sfc(st_point(c(1164434, 368738)),
                     st_point(c(1203023, 412959)),
                     crs = 3005)

  # Wrapping the call to `st_bbox()` in `local()` ensures that it
  # is executed in R to make a bounding box that is then sent to
  # the server for the filtering operation:
  res <- bcdc_query_geodata("local-and-regional-greenspaces") \%>\%
    filter(BBOX(local(st_bbox(two_points, crs = st_crs(two_points))))) \%>\%
    collect()
})
}
}
\keyword{internal}
