% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{rPosterior.CatDirichlet}
\alias{rPosterior.CatDirichlet}
\title{Generate ramdom samples from the posterior distribution of a "CatDirichlet" object}
\usage{
\method{rPosterior}{CatDirichlet}(obj, n = 1, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{n}{integer, the number of samples to be generated.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A matrix, each row is a sample of pi.
}
\description{
Generate random samples from the posterior distribution of the following structure:
     \deqn{pi|alpha \sim Dir(alpha)}
     \deqn{x|pi \sim Categorical(pi)}
Where Dir() is the Dirichlet distribution, Categorical() is the Categorical distribution. See \code{?dDir} and \code{dCategorical} for the definitions of these distribution. \cr
The model structure and prior parameters are stored in a "CatDirichlet" object. \cr
Posterior distribution is Dir(pi|alpha).
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=rep(1,26),uniqueLabels = letters))
rPosterior(obj = obj,n=3)
}
\seealso{
\code{\link{CatDirichlet}}, \code{\link{dPosterior.CatDirichlet}}
}
