% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dPosteriorPredictive.CatHDP2}
\alias{dPosteriorPredictive.CatHDP2}
\title{Posterior predictive density function of a "CatHDP" object}
\usage{
\method{dPosteriorPredictive}{CatHDP2}(obj, u, k, z, m, j, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatHDP" object.}

\item{u}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{k}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{z}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{m}{integer, group label.}

\item{j}{integer, subgroup label.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{G |eta \sim DP(eta,U)}
     \deqn{G_m|gamma \sim DP(gamma,G), m = 1:M}
     \deqn{pi_{mj}|G_m,alpha \sim DP(alpha,G_m), j = 1:J_m}
     \deqn{z|pi_{mj} \sim Categorical(pi_{mj})}
     \deqn{k|z,G_m \sim Categorical(G_m), \textrm{ if z is a sample from the base measure }G_m}
     \deqn{u|k,G \sim Categorical(G), \textrm{ if k is a sample from the base measure G}}
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G) is a Dirichlet Process on integers with concentration parameter gamma and base measure G. DP(alpha,G_m) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_m. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP2, u, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP" object. \cr
Posterior predictive density =  p(u,z,k|alpha,gamm,eta,U).
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP}}, \code{\link{dPosteriorPredictive.CatHDP}}
}
