% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma_Inference.r
\name{rInvGamma}
\alias{rInvGamma}
\title{Random number generation of Inverse-Gamma distribution}
\usage{
rInvGamma(n, shape, scale)
}
\arguments{
\item{n}{integer, number of samples to be generated.}

\item{shape}{numeric, the shape parameter of gamma distribution.}

\item{scale}{numeric, the scale, or inverse-scale parameter of gamma distribution. The 'rate' parameter in Gamma is the 'scale' parameter in InvGamma.}
}
\value{
A numeric vector, samples of Inverse-Gamma distribution.
}
\description{
Generation random samples from Inverse-Gamma distribution. For a random variable x, the density function is defined as:
   \deqn{(rate^shape)/Gamma(shape) x^{-shape-1} exp(-rate/x)}
Where Gamma() is the Gamma function.
}
