% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{posteriorDiscard.GaussianGaussian}
\alias{posteriorDiscard.GaussianGaussian}
\title{Update a "GaussianGaussian" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{GaussianGaussian}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "GaussianGaussian" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-Gaussian case the sufficient statistic of sample x is a object of type "ssGaussianMean", it can be generated by the function sufficientStatistics().}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the gamma stored in "obj" will be updated based on "ss".
}
\description{
For the model structure:
     \deqn{x ~ Gaussian(mu,Sigma)}
     \deqn{mu ~ Gaussian(m,S)}
Where Sigma is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
Contrary to posterior(), this function will update (m,S) by removing the information of observed samples x. The model structure and prior parameters are stored in a "GaussianGaussian" object, the prior parameters in this object will be updated after running this function.
}
\examples{
obj <- GaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),m=c(0.2,0.5),S=diag(2)))
obj
x <- rGaussian(100,c(0,0),Sigma = matrix(c(2,1,1,2),2,2))
ss <- sufficientStatistics(obj=obj,x=x,foreach = FALSE)
## update prior into posterior
posterior(obj = obj,ss = ss)
obj
## remove the information, back to prior
posteriorDiscard(obj = obj,ss = ss)
obj
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.
}
\seealso{
\code{\link{GaussianGaussian}},\code{\link{posterior.GaussianGaussian}},\code{\link{sufficientStatistics.GaussianGaussian}}
}
