% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{marginalLikelihood.CatDirichlet}
\alias{marginalLikelihood.CatDirichlet}
\title{Marginal likelihood of a "CatDirichlet" object}
\usage{
\method{marginalLikelihood}{CatDirichlet}(obj, x, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{x}{numeric/integer/character vector, observed Categorical samples.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of the following model structure:
     \deqn{pi|alpha ~ Dir(alpha)}
     \deqn{x|pi ~ Categorical(pi)}
Where Dir() is the Dirichlet distribution, Categorical() is the Categorical distribution. See \code{?dDir} and \code{dCategorical} for the definitions of these distribution. \cr
The model structure and prior parameters are stored in a "CatDirichlet" object. \cr
Marginal likelihood is the likelihood of x|alpha.
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26,1,2),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
marginalLikelihood(obj=obj,x=x,LOG = TRUE) #marginal likelihood
ss <- sufficientStatistics(obj = obj,x=x)
marginalLikelihood_bySufficientStatistics(obj=obj,ss = ss,LOG = TRUE)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}}, \code{\link{marginalLikelihood_bySufficientStatistics.CatDirichlet}}
}
