% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{posteriorDiscard}
\alias{posteriorDiscard}
\title{update the prior distribution with sufficient statistics}
\usage{
posteriorDiscard(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None, or an error message if the update fails.
}
\description{
Contrary to posterior(), posteriorDiscard() a generic function that will update the prior distribution of a "BayesianBrick" object by removing the information provided by the observation's sufficient statistics. i.e. for the model structure: \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
update gamma to gamma_posterior by removing the information of X from gamma
}
\seealso{
\code{\link{posterior.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{posterior.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{posterior.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{posterior.CatDP}} for Categorical-DP conjugate structure ...
}
