% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{posteriorDiscard.GaussianNIG}
\alias{posteriorDiscard.GaussianNIG}
\title{Update a "GaussianNIG" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{GaussianNIG}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{ss}{Sufficient statistics of (x,X). In Gaussian-NIG case the sufficient statistic of sample (x,X) is a object of type "ssGaussianLinear", it can be  generated by the function sufficientStatistics().}

\item{w}{Sample weights,default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the gamma stored in "obj" will be updated with the information in "ss".
}
\description{
For the model structure: \cr
     beta,sigma^2|gamma ~ NIG(gamma) \cr
     x|beta,sigma^2,X ~ Gaussian(X%*%beta,sigma^2) \cr
where gamma = (m,V,a,b) is the Normal-Inverse-Gamma(NIG) parameter, "m" is a numeric "location" parameter; "V" is a symmetric positive definite matrix representing the "scale" parameters; "a" and "b" are the "shape" and "rate" parameter of the Inverse Gamma distribution. \cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Contrary to posterior(), this function will update gamma by removing the information of observed samples (x,X). The model structure and prior parameters are stored in a "GaussianNIG" object, the prior parameters in this object will be updated after running this function.
}
\examples{
X <- 1:20
x <- rnorm(20)+ X*0.3
## add information, then remove them
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
ss <- sufficientStatistics(obj = obj,X=X,x=x)
posterior(obj = obj,ss = ss)
obj
posteriorDiscard(obj=obj,ss=ss)
obj
## or, add information, then remove them one by one
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
ssEach <- sufficientStatistics(obj = obj,X=X,x=x,foreach = TRUE)
for(sss in ssEach) posterior(obj = obj,ss = sss)
obj
for(sss in ssEach) posteriorDiscard(obj = obj,ss = sss)
obj
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Dowloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}},\code{\link{posterior.GaussianNIG}}
}
