% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{posterior.GaussianNIW}
\alias{posterior.GaussianNIW}
\title{Update a "GaussianNIW" object with sample sufficient statistics}
\usage{
\method{posterior}{GaussianNIW}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-NIW case the sufficient statistic of sample x is a object of type "ssGaussian", it can be  generated by the function sufficientStatistics().}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the gamma stored in "obj" will be updated based on "ss".
}
\description{
For the model structure: \cr
     theta|gamma ~ NIW(gamma) \cr
     x|theta ~ Gaussian(theta) \cr
where theta = (mu,Sigma) is the Gaussian parameter, gamma = (m,k,v,S) is the Normal-Inverse-Wishart(NIW) parameter. \cr
Update gamma by adding the information of newly observed samples x. The model structure and prior parameters are stored in a "GaussianNIW" object, the prior parameters in this object will be updated after running this function.
}
\examples{
x <- rGaussian(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
w <- runif(1000)
obj <- GaussianNIW(gamma=list(m=c(0,0),k=1,v=2,S=diag(2)))
obj
ss <- sufficientStatistics_Weighted(obj = obj,x=x,w=w,foreach = TRUE)
for(i in 1L:length(ss)) posterior(obj = obj,ss = ss[[i]])
obj
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}},\code{\link{posteriorDiscard.GaussianNIW}},\code{\link{sufficientStatistics.GaussianNIW}}
}
