% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{marginalLikelihood_bySufficientStatistics.CatDirichlet}
\alias{marginalLikelihood_bySufficientStatistics.CatDirichlet}
\title{Marginal likelihood of a "CatDirichlet" object, usnig sufficient statistics}
\usage{
\method{marginalLikelihood_bySufficientStatistics}{CatDirichlet}(obj, ss, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{ss}{Sufficient statistics of x. In Categorical-Dirichlet case the sufficient statistic of sample x can be either x itself, of an "ssCat" object generated by the function sufficientStatistics.CatDirichlet().}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of a set of observations of the following model structure: \cr
     pi|alpha ~ Dirichlet(alpha) \cr
     x|pi ~ Categorical(pi) \cr
the model structure and prior parameters are stored in a "CatDirichlet" object. \cr
Marginal likelihood is the likelihood of x|alpha
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26,1,2),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
marginalLikelihood(obj=obj,x=x,LOG = TRUE) #marginal likelihood
ss <- sufficientStatistics(obj = obj,x=x)
marginalLikelihood_bySufficientStatistics(obj=obj,ss = ss,LOG = TRUE)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
@seealso \code{\link{CatDirichlet}}, \code{\link{marginalLikelihood.CatDirichlet}}
}
