% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerNLoptr.R
\name{mlr_optimizers_nloptr}
\alias{mlr_optimizers_nloptr}
\alias{OptimizerNLoptr}
\title{Optimization via Non-linear Optimization}
\source{
Johnson, G S (2020).
\dQuote{The NLopt nonlinear-optimization package.}
\url{https://github.com/stevengj/nlopt}.
}
\description{
\code{OptimizerNLoptr} class that implements non-linear optimization. Calls
\code{\link[nloptr:nloptr]{nloptr::nloptr()}} from package \CRANpkg{nloptr}.
}
\section{Parameters}{

\describe{
\item{\code{algorithm}}{\code{character(1)}}
\item{\code{eval_g_ineq}}{\verb{function()}}
\item{\code{xtol_rel}}{\code{numeric(1)}}
\item{\code{xtol_abs}}{\code{numeric(1)}}
\item{\code{ftol_rel}}{\code{numeric(1)}}
\item{\code{ftol_abs}}{\code{numeric(1)}}
\item{\code{start_values}}{\code{character(1)}\cr
Create \code{random} start values or based on \code{center} of search space? In the
latter case, it is the center of the parameters before a trafo is applied.}
}

For the meaning of the control parameters, see \code{\link[nloptr:nloptr]{nloptr::nloptr()}} and
\code{\link[nloptr:nloptr.print.options]{nloptr::nloptr.print.options()}}.

The termination conditions \code{stopval}, \code{maxtime} and \code{maxeval} of
\code{\link[nloptr:nloptr]{nloptr::nloptr()}} are deactivated and replaced by the \link{Terminator}
subclasses. The x and function value tolerance termination conditions
(\code{xtol_rel = 10^-4}, \code{xtol_abs = rep(0.0, length(x0))}, \code{ftol_rel = 0.0} and
\code{ftol_abs = 0.0}) are still available and implemented with their package
defaults. To deactivate these conditions, set them to \code{-1}.
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
\donttest{
if (requireNamespace("nloptr")) {

  search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

  codomain = ps(y = p_dbl(tags = "minimize"))

  objective_function = function(xs) {
    list(y = as.numeric(xs)^2)
  }

  objective = ObjectiveRFun$new(
    fun = objective_function,
    domain = domain,
    codomain = codomain)


  # We use the internal termination criterion xtol_rel
  terminator = trm("none")
  instance = OptimInstanceSingleCrit$new(
    objective = objective,
    search_space = search_space,
    terminator = terminator)


  optimizer = opt("nloptr", algorithm = "NLOPT_LN_BOBYQA")

  # Modifies the instance by reference
  optimizer$optimize(instance)

  # Returns best scoring evaluation
  instance$result

  # Allows access of data.table of full path of all evaluations
  as.data.table(instance$archive)
}
}

}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerNLoptr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OptimizerNLoptr$new()}}
\item \href{#method-clone}{\code{OptimizerNLoptr$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format">}\href{../../bbotk/html/Optimizer.html#method-format}{\code{bbotk::Optimizer$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help">}\href{../../bbotk/html/Optimizer.html#method-help}{\code{bbotk::Optimizer$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="optimize">}\href{../../bbotk/html/Optimizer.html#method-optimize}{\code{bbotk::Optimizer$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print">}\href{../../bbotk/html/Optimizer.html#method-print}{\code{bbotk::Optimizer$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerNLoptr$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerNLoptr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
