% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{readFasta}
\alias{readFasta}
\title{Read FASTA File}
\usage{
readFasta(file, rownames = FALSE)
}
\arguments{
\item{file}{File name of FASTA input.}

\item{rownames}{Use the sequence annotation line in file (starts with
\code{'>'}) as the row names. Will fail if there are duplicate items.}
}
\value{
Data frame of each sequence in rows.
}
\description{
Read nucleotide sequence files in FASTA format
}
\details{
Sequence data in FASTA files are converted into data frame
suitable as input to \code{\link{bbl}}. If sequence lengths are different,
instances longer than those already read will be truncated. Empty sequences
are skipped.
}
\examples{
file <- tempfile('data')
write('>seq1', file)
write('atgcc', file, append=TRUE)
write('>seq2', file, append=TRUE)
write('gccaa', file, append=TRUE)
system(paste0('cat ',file))
x <- readFasta(file)
x
}
