% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods.R
\docType{class}
\name{bbl-class}
\alias{bbl-class}
\alias{bbl}
\alias{show,bbl-method}
\alias{[,bbl-method}
\title{Class \code{bbl} for Boltzmann Bayes Learner}
\usage{
\S4method{show}{bbl}(object)

\S4method{[}{bbl}(x, i, j, remove.const = TRUE)
}
\arguments{
\item{object}{Object of class \code{bbl} to display}

\item{x}{Object of class \code{bbl} to be subsetted}

\item{i}{Row index to keep}

\item{j}{Not used.}

\item{remove.const}{Remove predictor levels not found in data.}
}
\description{
Class \code{bbl} for Boltzmann Bayes Learner
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Display \code{bbl} object content

Show predictor levels, response groups, and sample size.

\item \code{[}: Subsetting of \code{bbl} object along rows (sample index)
}}

\section{Slots}{

\describe{
\item{\code{predictors}}{List of vectors of characters, each corresponding
to predictor factor levels.}

\item{\code{groups}}{Vector of characters for response factor levels.}

\item{\code{data}}{Data frame for training data. Expected to contain both
predictors and response.}

\item{\code{y}}{Character column name of response data in \code{data}.}

\item{\code{h}}{Bias parameters stored after training. List of length
equal to no. of response groups, each of which is a list of
length equal to no. of predictors, containing vectors of
length equal to each predictor factor levels:
\eqn{h_i^{(y)}(x)} represented by
\code{h[[y]][[i]][x]}.}

\item{\code{J}}{Interaction parameters stored after training. List of
length equal to no. of response groups, each of which is a
list of lists of dimension \eqn{m \times m}, where \eqn{m}
is the number of predictors. Each element is a matrix of
dimension \eqn{L_i \times L_j}, where \eqn{L_i} and \eqn{L_j}
are numbers of factor levels in predictor \code{i} and \code{j}:
\eqn{J_{ij}^{(y)}(x_1,x_2)} represented by
\code{J[[y]][[i]][[j]][x1,x2]}.}

\item{\code{lz}}{Slot used to store log partition function of response
groups.}
}}

\examples{
data <- data.frame(y=c('g1','g2','g2','g1','g1','g2'),
  x1=c(0,0,1,2,0,1), x2=c('a','a','b','a','b','b'))
x <- bbl(data)
x
x[1:3,]
}
