% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollfun.R
\name{rollfun}
\alias{rollfun}
\alias{make_idx}
\title{Moving windows with custom function}
\usage{
rollfun(x, k, fun = "mean", ..., .idx = NULL)

make_idx(k, n)
}
\arguments{
\item{x}{A vector.}

\item{k}{integer. Width of moving window; must be an integer between one and 
\code{length(x)}.}

\item{fun}{character or function. The function to be applied on moving subvectors of 
\code{x}.}

\item{...}{Additional arguments to be passed to \code{fun}.}

\item{.idx}{integer. A vector of indices that can be precalculated with the function 
\code{make_idx}.}

\item{n}{integer. Length of the input vector \code{x}.}
}
\description{
Windowed / rolling operations on a vector, with a custom function \code{fun} 
provided as input.
}
\examples{
set.seed(1)
x <- sample(1:10)
rollfun(x, k = 3)
rollfun(x, k = 3, fun = max)

}
\seealso{
Functions \code{roll_mean} and others in package \pkg{RcppRoll} for a more 
efficient implementation of \code{rollfun} to specific values of \code{fun}. 

Similarly, see functions \code{rollmean} and others in package \pkg{zoo} and 
functions \code{runmean} and others in package \pkg{caTools}.
}
