% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.wholenumber.R
\name{is.wholenumber}
\alias{is.wholenumber}
\alias{as.wholenumber}
\title{Test if the values of a vector are whole numbers}
\usage{
is.wholenumber(x, tolerance = sqrt(.Machine$double.eps))

as.wholenumber(x, ...)
}
\arguments{
\item{x}{a vector to be tested.}

\item{tolerance}{numeric. Differences smaller than tolerance are considered as equal.
The default value is close to \code{1.5e-8}.}

\item{...}{Additional arguments passed to or from other methods.}
}
\value{
A logical, \code{TRUE} if all values of \code{x} 
are whole numbers.
}
\description{
The function \code{is.wholenumber} tests if values of 
the numeric vector \code{x} are all whole numbers (up 
to a tolerance).

The function \code{as.wholenumber} is a synonym for 
\code{\link[base]{as.integer}}.
}
\examples{
x = c(1L, 10L)
is.integer(x)
is.wholenumber(x)

x = c(1, 10)
is.integer(x)
is.wholenumber(x) # here is the difference with 'is.integer'

is.wholenumber(1+10^(-7))
is.wholenumber(1+10^(-8))

}
