% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_refLine.R
\name{refLine}
\alias{refLine}
\title{Reference Line}
\usage{
refLine(horizontal, vertical, coefficients, Plot = list(name = "", what =
  "lines", type = "solid", width = "standard", symbol = "circle", filled = TRUE,
  size = 0.09, color = "black"), current = list(yaxis.log = FALSE, yaxis.rev =
  FALSE, xaxis.log = FALSE), xrange = c(NA, NA), yrange = c(NA, NA),
  log10 = FALSE)
}
\arguments{
\item{horizontal}{draw horizontal lines at the specified values.}

\item{vertical}{draw vertical lines at the specified values.}

\item{coefficients}{draw a fitted line from the coefficients of a regression
model.}

\item{Plot}{parameters defining the characteristics of the plot. See
\code{\link{setPlot}} for a description of the parameters. The argument \code{what} is
forced to "lines."}

\item{current}{the current parameters of the graph. Typically, this would be
the output from one of the graph creation functions like \code{xyPlot}.}

\item{xrange}{limit x-axis range for horizontal or regression lines}

\item{yrange}{limit y-axis range for vertical lines}

\item{log10}{logical, if \code{TRUE}, then log base 10 transform used in the 
regression model, otherwise either the natural log was used or no transform.}
}
\value{
Information about the graph.
}
\description{
Adds a reference line (vertical, horizontal, or regression) to a graph.
}
\details{
Added from smwrGraphs.
}
\examples{
\dontrun{
set.seed(1)
X <- rnorm(32)
Y <- X + rnorm(32)
setGD()
xyPlot(X, Y)
# Add the 1:1 line
refLine(coefficient=c(0,1))
# For more details of refLine see
vignette(topic="GraphAdditions", package="smwrGraphs")
demo(topic="Coplot-complexScatterPlot", package="smwrGraphs")
}
}
\keyword{aplot}
\keyword{internal}
