% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_gamma_poisson.R
\name{summarize_gamma_poisson}
\alias{summarize_gamma_poisson}
\title{Summarize the Gamma-Poisson Model}
\usage{
summarize_gamma_poisson(shape, rate, sum_y = NULL, n = NULL)
}
\arguments{
\item{shape}{positive shape parameter of the Gamma prior}

\item{rate}{positive rate parameter of the Gamma prior}

\item{sum_y}{sum of observed data values for the Poisson likelihood}

\item{n}{number of observations for the Poisson likelihood}
}
\value{
data frame
}
\description{
Consider a Gamma-Poisson Bayesian model for rate parameter \eqn{\lambda} with 
a Gamma(shape, rate) prior on \eqn{\lambda} and a Poisson likelihood for the data. 
Given information on the prior (shape and rate) 
and data (the sample size n and sum_y),
this function summarizes the mean, mode, and variance of the 
prior and posterior Gamma models of \eqn{\lambda}.
}
\examples{
summarize_gamma_poisson(shape = 3, rate = 4, sum_y = 7, n = 12)

}
