% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-combo.R
\name{MCMC-combos}
\alias{MCMC-combos}
\alias{mcmc_combo}
\title{Combination plots}
\usage{
mcmc_combo(x, combo = c("dens", "trace"), ..., widths = NULL,
  gg_theme = NULL)
}
\arguments{
\item{x}{A 3-D array, matrix, list of matrices, or data frame of MCMC draws.
The \link{MCMC-overview} page provides details on how to specify each these
allowed inputs. It is also possible to use an object with an
\code{as.array()} method that returns the same kind of 3-D array described on
the \link{MCMC-overview} page.}

\item{combo}{A character vector with at least two elements. Each element of
\code{combo} corresponds to a column in the resulting graphic and should be the
name of one of the available \link[=MCMC-overview]{MCMC} functions (omitting the
\code{mcmc_} prefix).}

\item{...}{Arguments passed to the plotting functions named in \code{combo}.}

\item{widths}{A numeric vector the same length as \code{combo} specifying
relative column widths. For example, if the plot has two columns, then
\code{widths = c(2, 1)} will allocate more space for the first column by a
factor of 2 (as would \code{widths = c(.3, .15)}, etc.). The default,
\code{NULL}, allocates the same horizontal space for each column.}

\item{gg_theme}{Unlike most of the other \strong{bayesplot} functions,
\code{mcmc_combo} returns a gtable object rather than a ggplot object, and
so theme objects can't be added directly to the returned plot object. The
\code{gg_theme} argument helps get around this problem by accepting a
\strong{ggplot2} \link[ggplot2:theme]{theme} object that is added to each of the
plots \emph{before} combining them into the gtable object that is returned.
This can be a theme object created by a call to \code{\link[ggplot2:theme]{ggplot2::theme()}} or
one of the \strong{bayesplot} convenience functions, e.g.
\code{\link[=legend_none]{legend_none()}} (see the \strong{Examples} section, below).}
}
\value{
A gtable object (the result of calling
\code{\link[gridExtra:arrangeGrob]{gridExtra::arrangeGrob()}}) with \code{length(combo)} columns and
a row for each parameter.
}
\description{
Combination plots
}
\examples{
# some parameter draws to use for demonstration
x <- example_mcmc_draws()
dim(x)
dimnames(x)

mcmc_combo(x, pars = c("alpha", "sigma"))
mcmc_combo(x, pars = c("alpha", "sigma"), widths = c(1, 2))

\donttest{
# change second plot, show log(sigma) instead of sigma,
# and remove the legends
color_scheme_set("mix-blue-red")
mcmc_combo(
 x,
 combo = c("dens_overlay", "trace"),
 pars = c("alpha", "sigma"),
 transformations = list(sigma = "log"),
 gg_theme = legend_none()
)

# same thing but this time also change the entire ggplot theme
mcmc_combo(
 x,
 combo = c("dens_overlay", "trace"),
 pars = c("alpha", "sigma"),
 transformations = list(sigma = "log"),
 gg_theme = ggplot2::theme_gray() + legend_none()
)
}

}
\seealso{
Other MCMC: \code{\link{MCMC-diagnostics}},
  \code{\link{MCMC-distributions}},
  \code{\link{MCMC-intervals}}, \code{\link{MCMC-nuts}},
  \code{\link{MCMC-overview}}, \code{\link{MCMC-parcoord}},
  \code{\link{MCMC-recover}},
  \code{\link{MCMC-scatterplots}},
  \code{\link{MCMC-traces}}
}
\concept{MCMC}
