% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesplot-ggplot-themes.R
\name{theme_default}
\alias{theme_default}
\title{Default plotting theme}
\usage{
theme_default(base_size = getOption("bayesplot.base_size", 12),
  base_family = getOption("bayesplot.base_family", "serif"))
}
\arguments{
\item{base_size, base_family}{Base font size and family (passed to
\code{\link[ggplot2]{theme_bw}}). It is possible to set
\code{"bayesplot.base_size"} and \code{"bayesplot.base_family"} via
\code{\link{options}} to change the defaults, which are \code{12} and
\code{"serif"}, respectively.}
}
\value{
A ggplot \link[ggplot2]{theme} object.
}
\description{
The \code{\link{theme_default}} function returns the default ggplot
\link{theme} used by the \pkg{bayesplot} plotting functions. Many of the
individual plotting functions also make small alterations to the default
theme using the convenience functions documented at \link{bayesplot-helpers}.
To use a different theme simply add that theme to the ggplot objects created
by the \pkg{bayesplot} plotting functions (see \strong{Examples}, below).
}
\examples{
thm <- theme_default()
class(thm)
names(thm)

# plot using the default theme
x <- example_mcmc_draws()
mcmc_hist(x)

# change the default font size and family
options(bayesplot.base_size = 10,
        bayesplot.base_family = "sans")
mcmc_hist(x)
mcmc_areas(x, regex_pars = "beta")

# change back
options(bayesplot.base_size = 12,
        bayesplot.base_family = "serif")
mcmc_areas(x, regex_pars = "beta")

# use one of the themes included in ggplot2
mcmc_dens_overlay(x) + ggplot2::theme_gray()

}
\seealso{
\link{bayesplot-helpers} for a variety of convenience functions,
  many of which provide shortcuts for tweaking theme elements after creating
  a plot.

\code{\link{bayesplot-colors}} to set or view the color scheme used
  for plotting.
}
