% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{traceplot}
\alias{traceplot}
\title{View trace-plots of output from Bayesian segmentation model}
\usage{
traceplot(data, ngibbs, type)
}
\arguments{
\item{data}{A data frame containing values at each iteration of the MCMC
chain where each row holds data for a specific animal ID.}

\item{ngibbs}{numeric. The total number of iterations of the MCMC chain.}

\item{type}{character. The type of data that are being plotted from the
Bayesian segmentation model results. Takes either 'nbrks' for the number of
breakpoints or 'LML' for the log marginal likelihood.}
}
\value{
Trace-plots for the number of breakpoints or the log marginal
  likelihood are displayed for each of the animal IDs that were analyzed by
  the segmentation model.
}
\description{
Visualize trace-plots of the number of breakpoints estimated by the model as
well as the log marginal likelihood (LML) for each animal ID.
}
\examples{
#simulate data
ngibbs<- 1000
y<- (-1000 * 501:1500)/(-500 + 501:1500) + rnorm(ngibbs, 0, 0.1)
dat<- matrix(c(1, y), 1, 1001)
dat<- data.frame(dat)
names(dat)[1]<- "id"

#run function
traceplot(data = dat, ngibbs = ngibbs, type = "LML")

}
