% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{discrete_move_var}
\alias{discrete_move_var}
\title{Discretize movement variables}
\usage{
discrete_move_var(dat, lims, varIn, varOut)
}
\arguments{
\item{dat}{A data frame that contains the variable(s) of interest to convert
from continuous to discrete values.}

\item{lims}{A list of the bin limits for each variable. Each element of the
list should be a vector of real numbers.}

\item{varIn}{A vector of names for the continuous variable stored as columns
within \code{dat}.}

\item{varOut}{A vector of names for the storage of the discrete variables
returned by the function.}
}
\value{
A data frame with new columns of discretized variables as labeled by
  \code{varOut}.
}
\description{
Convert movement variables from continuous to discrete values for analysis by
\code{\link{segment_behavior}}.
}
\examples{
#load data
data(tracks)

#subset only first track
tracks<- tracks[tracks$id == "id1",]

#calculate step lengths and turning angles
tracks<- prep_data(dat = tracks, coord.names = c("x","y"), id = "id")

#round times to nearest interval of interest (e.g. 3600 s or 1 hr)
tracks<- round_track_time(dat = tracks, id = "id", int = 3600, tol = 180, time.zone = "UTC")

#create list from data frame
tracks.list<- df_to_list(dat = tracks, ind = "id")

#filter observations to only 1 hr (or 3600 s)
tracks_filt.list<- filter_time(dat.list = tracks.list, int = 3600)

#define bin number and limits for turning angles and step lengths
angle.bin.lims=seq(from=-pi, to=pi, by=pi/4)  #8 bins
dist.bin.lims=quantile(tracks[tracks$dt == 3600,]$step,
                      c(0,0.25,0.50,0.75,0.90,1), na.rm=TRUE)  #5 bins


# Assign bins to observations
tracks_disc.list<- purrr::map(tracks_filt.list,
                      discrete_move_var,
                      lims = list(dist.bin.lims, angle.bin.lims),
                      varIn = c("step", "angle"),
                      varOut = c("SL", "TA"))


}
