% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_gibbs_sampler.R
\name{cluster_segments}
\alias{cluster_segments}
\title{Cluster time segments into behavioral states}
\usage{
cluster_segments(dat, gamma1, alpha, ngibbs, nmaxclust, nburn, ndata.types)
}
\arguments{
\item{dat}{A data frame returned by \code{\link{summarize_tsegs}} that
summarizes the counts of observations per bin and movement variable for all
animal IDs.}

\item{gamma1}{numeric. A hyperparameter for the truncated stick-breaking
prior for estimating the \code{theta} matrix.}

\item{alpha}{numeric. A hyperparameter for the Dirichlet distribution when
estimating the \code{phi} matrix.}

\item{ngibbs}{numeric. The total number of iterations of the MCMC chain.}

\item{nmaxclust}{numeric. A single number indicating the maximum number of
clusters to test.}

\item{nburn}{numeric. The length of the burn-in phase.}

\item{ndata.types}{numeric. A vector of the number of bins used to discretize
each movement variable. These must be in the same order as the columns
within \code{dat}.}
}
\value{
A list of model results is returned where elements include the
  \code{phi} matrix for each data stream, \code{theta} matrix, log likelihood
  estimates for each iteration of the MCMC chain \code{loglikel}, and
  matrices of the latent cluster estimates for each data stream \code{z.agg}.
}
\description{
This function performs a Gibbs sampler within the Latent Dirichlet Allocation
(LDA) model to estimate proportions of each behavioral state for all time
segments generated by \code{\link{segment_behavior}}. This is the second
stage of the two-stage Bayesian model that estimates proportions of
behavioral states by first segmenting individual tracks into relatively
homogeneous segments of movement.
}
\details{
The LDA model provides behavior estimates for all animal IDs pooled together,
providing population-level estimates of animal behavioral states.
}
\examples{
\donttest{
#load data
data(tracks.seg)

#select only id, tseg, SL, and TA columns
tracks.seg2<- tracks.seg[,c("id","tseg","SL","TA")]

#summarize data by track segment
obs<- summarize_tsegs(dat = tracks.seg2, nbins = c(5,8))

#cluster data with LDA
res<- cluster_segments(dat = obs, gamma1 = 0.1, alpha = 0.1, ngibbs = 1000,
                       nburn = 500, nmaxclust = 7, ndata.types = 2)
}

}
