% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-sarima_params.R
\name{sarima_params}
\alias{sarima_params}
\alias{non_seasonal_ar}
\alias{non_seasonal_differences}
\alias{non_seasonal_ma}
\alias{seasonal_ar}
\alias{seasonal_differences}
\alias{seasonal_ma}
\alias{markov_chains}
\alias{adapt_delta}
\alias{tree_depth}
\title{Tuning Parameters for SARIMA Models}
\usage{
non_seasonal_ar(range = c(0L, 5L), trans = NULL)

non_seasonal_differences(range = c(0L, 2L), trans = NULL)

non_seasonal_ma(range = c(0L, 5L), trans = NULL)

seasonal_ar(range = c(0L, 2L), trans = NULL)

seasonal_differences(range = c(0L, 1L), trans = NULL)

seasonal_ma(range = c(0L, 2L), trans = NULL)

markov_chains(range = c(0L, 8L), trans = NULL)

adapt_delta(range = c(0, 1), trans = NULL)

tree_depth(range = c(0L, 100L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter
}
\description{
Tuning Parameters for SARIMA Models
}
\details{
The main parameters for SARIMA models are:
\itemize{
\item \code{non_seasonal_ar}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{non_seasonal_differences}: The order of integration for non-seasonal differencing.
\item \code{non_seasonal_ma}: The order of the non-seasonal moving average (MA) terms.
\item \code{seasonal_ar}: The order of the seasonal auto-regressive (SAR) terms.
\item \code{seasonal_differences}: The order of integration for seasonal differencing.
\item \code{seasonal_ma}: The order of the seasonal moving average (SMA) terms.
\item \code{markov_chains}: The number of markov chains.
\item \code{adapt_delta}: The thin of the jumps in a HMC method
\item \code{tree_depth}: Maximum depth of the trees
}
}
\examples{
non_seasonal_ar()

non_seasonal_differences()

non_seasonal_ma()


}
