% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctionsSlurm.R
\name{makeClusterFunctionsSlurm}
\alias{makeClusterFunctionsSlurm}
\title{ClusterFunctions for Slurm Systems}
\usage{
makeClusterFunctionsSlurm(template = findTemplateFile("slurm"),
  clusters = NULL)
}
\arguments{
\item{template}{[\code{character(1)}]\cr
Path to a brew template file that can be used for the job description.
Alternatively, the template as a single string (including at least one newline \dQuote{\\n}).
Defaults to a heuristic which looks for a template file in the following locations and picks
the first one found:
\enumerate{
  \item \dQuote{batchtools.slurm.tmpl} in the current working directory.
  \item \dQuote{slurm.tmpl} in the user config directory (see \code{\link[rappdirs]{user_config_dir}}); on linux is is usually \dQuote{~/.config/batchtools/slurm.tmpl}.
  \item \dQuote{.batchtools.slurm.tmpl} in the home directory.
  \item \dQuote{slurm.default.tmpl} in the package installation directory in the subfolder \dQuote{templates} (this probably does not exist for your cluster system or needs adaptation).
}}

\item{clusters}{[\code{character(1)}]\cr
If multiple clusters are managed by one Slurm system, the name of one cluster has to be specified.
If only one cluster is present, this argument may be omitted.
Note that you should not select the cluster in your template file via \code{#SBATCH --clusters}.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
Job files are created based on the brew template \code{template.file}. This
file is processed with brew and then submitted to the queue using the
\code{sbatch} command. Jobs are killed using the \code{scancel} command and
the list of running jobs is retrieved using \code{squeue}. The user must
have the appropriate privileges to submit, delete and list jobs on the
cluster (this is usually the case).

The template file can access all resources passed to \code{\link{submitJobs}}
as well as all variables stored in the \code{\link{JobCollection}}.
It is the template file's job to choose a queue for the job and handle the desired resource
allocations.

Note that you might have to specify the cluster name here if you do not want to use the default,
otherwise the commands for listing and killing jobs will not work.
}
\seealso{
Other ClusterFunctions: \code{\link{makeClusterFunctionsDocker}},
  \code{\link{makeClusterFunctionsInteractive}},
  \code{\link{makeClusterFunctionsLSF}},
  \code{\link{makeClusterFunctionsMulticore}},
  \code{\link{makeClusterFunctionsOpenLava}},
  \code{\link{makeClusterFunctionsSGE}},
  \code{\link{makeClusterFunctionsSSH}},
  \code{\link{makeClusterFunctionsSocket}},
  \code{\link{makeClusterFunctionsTorque}},
  \code{\link{makeClusterFunctions}}
}

