% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkIds.R
\name{chunkIds}
\alias{chunkIds}
\title{Chunk Jobs for Sequential Execution}
\usage{
chunkIds(ids = NULL, n.chunks = NULL, chunk.size = NULL,
  group.by = character(0L), reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.}

\item{n.chunks}{[\code{integer(1)}]\cr
Requested number of chunks.
If more chunks than elements in \code{ids} are requested, empty chunks are ignored.
Mutually exclusive with \code{chunks.size}.}

\item{chunk.size}{[\code{integer(1)}]\cr
Requested number of elements in each chunk.
If \code{ids} cannot be chunked evenly, some chunks will have less elements than others.
Mutually exclusive with with \code{n.chunks}.}

\item{group.by}{[\code{character(0)}]\cr
If \code{ids} is a \code{\link{data.frame}} with additional columns
(in addition to the required column \dQuote{job.id}), then the chunking is performed using
subgroups defined by the columns set in \code{group.by}.
See example.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link[data.table]{data.table}}] with columns \dQuote{job.id} and \dQuote{chunk}.
}
\description{
Partition jobs into \dQuote{chunks} which will be executed together on the nodes.

Chunks are submitted via \code{\link{submitJobs}} by simply providing
a data frame with columns \dQuote{job.id} and corresponding \dQuote{chunk} (both integer).
All jobs with the same chunk number will be grouped together on one node as a single
computational job.

If neither \code{n.chunks} nor \code{chunk.size} are provided, each job will be assigned
to its own chunk.
}
\examples{
# chunking for Registry
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(identity, 1:25, reg = tmp)
ids = chunkIds(chunk.size = 10, reg = tmp)
print(ids)
print(table(ids$chunk))

# Creating chunks for an ExperimentRegistry
tmp = makeExperimentRegistry(file.dir = NA, make.default = FALSE)
prob = addProblem(reg = tmp, "prob1", data = iris, fun = function(job, data) nrow(data))
prob = addProblem(reg = tmp, "prob2", data = Titanic, fun = function(job, data) nrow(data))
algo = addAlgorithm(reg = tmp, "algo", fun = function(job, data, instance, i, ...) problem)
prob.designs = list(prob1 = data.table(), prob2 = data.table(x = 1:2))
algo.designs = list(algo = data.table(i = 1:3))
addExperiments(prob.designs, algo.designs, repls = 3, reg = tmp)

# group into chunks of 5 jobs, but do not put multiple problems into a single chunk
# -> only one problem has to be loaded per chunk, and only once because it is then cached.
ids = getJobTable(reg = tmp)[, .(job.id, problem, algorithm)]
chunked = chunkIds(ids, chunk.size = 5, group.by = "problem", reg = tmp)
print(chunked)
dcast(ijoin(ids, chunked), chunk ~ problem)
}

