% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareInitialParameters.R
\name{prepareInitialParameters}
\alias{prepareInitialParameters}
\title{Prepare initial values}
\usage{
prepareInitialParameters(
  initial_class_means,
  initial_class_covariance,
  initial_batch_shift,
  initial_batch_scale,
  initial_class_df,
  P,
  K,
  B,
  type
)
}
\arguments{
\item{initial_class_means}{A $P x K$ matrix of initial values for the class
means. Defaults to draws from the prior distribution.}

\item{initial_class_covariance}{A $P x P x K$ array of initial values for the
class covariance matrices. Defaults to draws from the prior distribution.}

\item{initial_batch_shift}{A $P x B$ matrix of initial values for the batch
shift effect Defaults to draws from the prior distribution.}

\item{initial_batch_scale}{A $P x B$ matrix of initial values for the batch
scales Defaults to draws from the prior distribution.}

\item{initial_class_df}{A $K$ vector of initial values for the class degrees
of freedom. Defaults to draws from the prior distribution.}

\item{P}{Integer. The number of measurements for each sample in the dataset
being modelled.}

\item{K}{The number of classes/clusters being modelled.}

\item{B}{The number of batches being modelled.}

\item{type}{The type of mixture model used; one of "MVN" or "MVT".}
}
\value{
A named list containing the different parameters.
}
\description{
Prepares user given values for input into the C++ function.
}
