% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectAcceptanceRates.R
\name{collectAcceptanceRates}
\alias{collectAcceptanceRates}
\title{Collect acceptance rate}
\usage{
collectAcceptanceRates(samples, type)
}
\arguments{
\item{samples}{The output of either the ``batchMixtureModel`` or 
``batchSemiSupervisedMixtureModel`` function.}

\item{type}{The type of mixture model used; this changes which parameters
the function expects to find.}
}
\value{
A wide data.frame of all the sampled parameters and the iteration.
}
\description{
Collects the acceptance rates for each parameter into a data.frame
}
\examples{

# Data in a matrix format
X <- matrix(c(rnorm(100, 0, 1), rnorm(100, 3, 1)), ncol = 2, byrow = TRUE)

# Initial labelling
labels <- c(rep(1, 10), 
  sample(c(1,2), size = 40, replace = TRUE), 
  rep(2, 10), 
  sample(c(1,2), size = 40, replace = TRUE)
)

fixed <- c(rep(1, 10), rep(0, 40), rep(1, 10), rep(0, 40))

# Batch
batch_vec <- sample(seq(1, 5), replace = TRUE, size = 100)

# Sampling parameters
R <- 1000
thin <- 50

# MCMC samples and BIC vector
samples <- batchSemiSupervisedMixtureModel(X, R, thin, labels, fixed, batch_vec, "MVN")

# Acceptance rates
collectAcceptanceRates(samples, "MVN")

}
