% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monotonicity.R
\name{check_mon_within}
\alias{check_mon_within}
\alias{check_mon_within,OneStageBasket-method}
\title{Check Within-Trial Monotonicity}
\usage{
check_mon_within(design, ...)

\S4method{check_mon_within}{OneStageBasket}(
  design,
  n,
  lambda,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  details = TRUE,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{details}{Whether the cases where the monotonicity condition is
violated should be returned, in case there are any.}
}
\value{
If \code{details = FALSE} then only a logical value is returned.
If \code{details = TRUE} then if there are any cases where the
within-trial monotonicity condition is violated, a list of these cases and
their results are returned. If at least one tuning parameter is a vector,
then an array that shows for which combination of parameters the
within-trial monotonicity condition holds. In this case, the argument
\code{details} is ignored.
}
\description{
Checks whether the within-trial monotonicity condition holds.
}
\details{
\code{check_mon_within} checks whether the within-trial
monotonicity condition holds. For a single-stage design with equal
prior distributions and equal sample sizes for each basket this condition
states that there are no cases where the null hypothesis of a basket is
rejected when there is at least one other basket with more observed
responses for which the null hypothesis cannot be rejected.

If \code{prune = TRUE} then the baskets with an observed number of baskets
smaller than the pooled critical value are not borrowed from. The
pooled critical value is the smallest integer c for which all null
hypotheses can be rejected if the number of responses is exactly c for
all baskets.

The function is vectorized, such that vectors can be specified in
\code{weight_params} and \code{globalweight_params}.
}
\section{Methods (by class)}{
\itemize{
\item \code{check_mon_within(OneStageBasket)}: Within-trial monotonicity condition for a
single-stage design.

}}
\examples{
design <- setupOneStageBasket(k = 4, shape1 = 1, shape2 = 1, p0 = 0.2)

# Without vectorization, with details
design <- setupOneStageBasket(k = 4, shape1 = 1, shape2 = 1, p0 = 0.2)
check_mon_within(design = design, n = 24, lambda = 0.99,
  weight_fun = weights_fujikawa, weight_params = list(epsilon = 0.5,
   tau = 0), details = TRUE)

# Vectorized
\donttest{check_mon_within(design = design, n = 24, lambda = 0.99,
  weight_fun = weights_fujikawa,
  weight_params = list(epsilon = c(0.5, 1),  tau = c(0, 0.2, 0.3)),
  globalweight_fun = globalweights_fix,
  globalweight_params = list(w = c(0.5, 0.7)))}
}
\references{
Baumann, L., Krisam, J., & Kieser, M. (2022). Monotonicity conditions for
avoiding counterintuitive decisions in basket trials. Biometrical Journal,
64(5), 934-947.
}
