% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/monotonicity.R
\name{check_mon_between}
\alias{check_mon_between}
\alias{check_mon_between,OneStageBasket-method}
\title{Check Between-Trial Monotonicity}
\usage{
check_mon_between(
  design,
  n,
  lambda,
  epsilon,
  tau,
  logbase = 2,
  prune,
  details,
  ...
)

\S4method{check_mon_between}{OneStageBasket}(
  design,
  n,
  lambda,
  epsilon,
  tau,
  logbase = 2,
  prune,
  details,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupBasket}.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{epsilon}{A tuning parameter that determines the amount of borrowing.
See details for more information.}

\item{tau}{A tuning parameter that determines how similar the baskets
have to be that borrowing occurs. See details for more information.}

\item{logbase}{A tuning parameter that determines which logarithm base is
used to compute the Jensen-Shannon divergence. See details for more
information.}

\item{prune}{Whether baskets with a number of responses below the
critical pooled value should be pruned before the final analysis.}

\item{details}{Whether the cases where the monotonicity condition is
violated should be returned, in case there are any.}

\item{...}{Further arguments.}
}
\value{
If \code{details = FALSE} then only a logical value is returned.
If \code{details = TRUE} then if there are any cases where the
between-trial monotonicity condition is violated, a list of theses cases
and their results are returned.
}
\description{
Checks whether the between-trial monotonicity condition holds.
}
\details{
\code{check_mon_between} checks whether the between-trial
monotonicity condition holds. For a single-stage design with equal prior
distributions and equal sample sizes for each basket this condition states
that there are no cases where at least one null hypothesis is rejected when
when there is a case with an equal or higher number of responses in each
basket for which no null hypothesis is rejected.

If \code{prune = TRUE} then the baskets with an observed number of baskets
smaller than the pooled critical value are not borrowed from. The
pooled critical value is the smallest integer c for which all null
hypotheses can be rejected if the number of responses is exactly c for
all baskets.

This method is implemented for the class \code{\link{OneStageBasket}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{OneStageBasket}: Between-trial monotonicity condition for a
single-stage design.
}}

\examples{
design <- setupOneStageBasket(k = 4, shape1 = 1, shape2 = 1, theta0 = 0.2)
check_mon_between(design = design, n = 24, lambda = 0.99, epsilon = 3,
  tau = 0, prune = FALSE, details = TRUE)
}
