% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_pbp.R
\name{ncaa_pbp}
\alias{ncaa_pbp}
\title{\strong{Get Play-By-Play Data for NCAA Baseball Games}}
\usage{
ncaa_pbp(
  game_info_url = NA_character_,
  game_pbp_url = NA_character_,
  raw_html_to_disk = FALSE,
  raw_html_path = "/",
  read_from_file = FALSE,
  file = NA_character_,
  ...
)
}
\arguments{
\item{game_info_url}{The url for the game's boxscore data. This can be
found using the ncaa_schedule_info function.}

\item{game_pbp_url}{The url for the game's play-by-play data. This can be
found using the ncaa_schedule_info function.}

\item{raw_html_to_disk}{Write raw html to disk (saves as {game_pbp_id}.html
in \code{raw_html_path} directory)}

\item{raw_html_path}{Directory path to write raw html}

\item{read_from_file}{Read from raw html on disk}

\item{file}{File with full path to read raw html}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
A data frame with play-by-play data for an individual game.\tabular{ll}{
   col_name \tab types \cr
   game_date \tab character \cr
   location \tab character \cr
   attendance \tab logical \cr
   inning \tab character \cr
   inning_top_bot \tab character \cr
   score \tab character \cr
   batting \tab character \cr
   fielding \tab character \cr
   description \tab character \cr
   game_pbp_url \tab character \cr
   game_pbp_id \tab integer \cr
}
}
\description{
\strong{Get Play-By-Play Data for NCAA Baseball Games}
}
\examples{
\donttest{
  try(ncaa_pbp(game_info_url = "https://stats.ncaa.org/contests/2167178/box_score"))
}
}
