% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptrc_league_payrolls.R
\name{sptrc_league_payrolls}
\alias{sptrc_league_payrolls}
\title{\strong{Scrape League Payroll Breakdowns from Spotrac}}
\usage{
sptrc_league_payrolls(year = most_recent_mlb_season())
}
\arguments{
\item{year}{Year to load}
}
\value{
A data frame of contract data.\tabular{ll}{
   col_name \tab types \cr
   year \tab character \cr
   team \tab character \cr
   team_abbr \tab character \cr
   rank \tab numeric \cr
   win_percent \tab numeric \cr
   roster \tab numeric \cr
   active_man_payroll \tab numeric \cr
   injured_reserve \tab numeric \cr
   retained \tab numeric \cr
   buried \tab numeric \cr
   suspended \tab numeric \cr
   yearly_total_payroll \tab numeric \cr
}
}
\description{
This function allows you to scrape each team's payroll from Spotrac.
}
\examples{
\donttest{
  try(sptrc_league_payrolls(year = most_recent_mlb_season()))
}
}
