% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VSUP.R
\docType{data}
\name{ScaleBivariate}
\alias{ScaleBivariate}
\alias{bivariate_scale}
\title{Constructor for bivariate scale object}
\format{
An object of class \code{ScaleBivariate} (inherits from \code{Scale}, \code{ggproto}, \code{gg}) of length 15.
}
\usage{
bivariate_scale(
  aesthetics,
  palette,
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  rescaler = scales::rescale,
  oob = scales::censor,
  expand = waiver(),
  na.value = NA_real_,
  trans = "identity",
  guide = "none",
  super = ScaleBivariate,
  scale_name = "bivariate_scale"
)
}
\arguments{
\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding output values
(e.g., \code{\link[scales:area_pal]{scales::area_pal()}}).}

\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{Data frame with two columns of length two each defining the limits for the two data dimensions.}

\item{rescaler}{Either one rescaling function applied to both data dimensions or list of two rescaling functions,
one for each data dimension.}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{na.value}{Missing values will be replaced with this value.}

\item{trans}{Either one transformation applied to both data dimensions or list of two transformations, one
for each data dimension. Transformations can be given as either the name of a transformation object
or the object itself. See [`ggplot2::continuous_scale()`] for details.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{super}{The super class to use for the constructed scale}

\item{scale_name}{The name of the scale that should be used for error messages
associated with this scale.}
}
\description{
Constructor for bivariate scale object
}
\keyword{datasets}
