% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{stations_create}
\alias{stations_create}
\alias{stations_assign}
\alias{stations_names}
\alias{stations_cells}
\alias{stations}
\title{Work with stations}
\usage{
stations_create(station_names, cells)

stations_assign(pheno, stations)

stations_names(stations)

stations_cells(stations)
}
\arguments{
\item{station_names}{Character vector that specifies the names of the stations.}

\item{cells}{Numbers of the cells that should be represented by the stations.}

\item{pheno}{A  phenology (see \code{\link[=phenology]{phenology()}})}

\item{stations}{Stations created with \code{stations_create()} or obtained by
\code{\link[=prop_stations]{prop_stations()}}.}
}
\value{
\itemize{
\item \code{stations_create()}: A named numeric vector.
\item \code{stations_assign()}: A phenology object (see \code{\link[=phenology]{phenology()}}).
\item \code{stations_names()}: A character vector.
\item \code{stations_cells()}: A numeric vector.
}
}
\description{
In \code{barrks}, stations are references to specific raster cells. Thus, they
can be used to extract point-related data from a phenology. Look
\link[=analyse.phenology]{here} to find out which station-based functions are
available to analyse a phenology.
}
\section{Functions}{
\itemize{
\item \code{stations_create()}: Create stations.

\item \code{stations_assign()}: Assign stations to a phenology. Returns the phenology
that was passed with respective stations assigned.

\item \code{stations_names()}: Get the names of stations.

\item \code{stations_cells()}: Get the raster cells of stations.

}}
\examples{
\donttest{
# calculate phenology
p <- phenology('phenips-clim', barrks_data(), .quiet = TRUE)

# create stations and assign them to the phenology object
stations <- stations_create(c('station a', 'station b'),
                            c(234, 345))
p <- stations_assign(p, stations)

# plot the development of 'station b'
plot_development_diagram(p, 'station b', .lwd = 4, .legend_lty = FALSE)
}
}
