% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexpfit.R
\name{dexpfit}
\alias{dexpfit}
\title{Estimate Exponential Growth rate from  Aoristic data}
\usage{
dexpfit(
  x,
  niter = 1e+05,
  nburnin = 50000,
  thin = 10,
  nchains = 4,
  r1Prior = "dnorm(mean=0,sd=0.05)",
  r2Prior = "dnorm(mean=0,sd=0.05)",
  etaPrior = "dunif(min=1,max=z)",
  r1Sampler = NULL,
  r2Sampler = NULL,
  etaSampler = NULL,
  parallel = FALSE,
  seeds = 1:4
)
}
\arguments{
\item{x}{A ProbMat class object}

\item{niter}{Number of MCMC iterations. Default is 500,000.}

\item{nburnin}{Number of iterations discarded for burn-in. Default is 250,000.}

\item{thin}{Thinning interval}

\item{nchains}{Number of MCMC chains}

\item{r1Prior}{A string defining prior for the growth parameter r1. Default is 'dnorm(mean=0,sd=0.05)'.}

\item{r2Prior}{A string defining prior for the growth parameter r2. Default is 'dnorm(mean=0,sd=0.05)'.}

\item{etaPrior}{A string defining prior for the change point parameter eta. Default is 'dunif(1,z)', where 'z' is the number of time-blocks.}

\item{r1Sampler}{A list containing settings for the MCMC sampler. Default is null and employs nimble's Default sampler (RW sampler).}

\item{r2Sampler}{A list containing settings for the MCMC sampler. Default is null and employs nimble's Default sampler (RW sampler).}

\item{etaSampler}{A list containing settings for the MCMC sampler. Default is null and employs nimble's Default sampler (RW sampler).}

\item{parallel}{Logical specifying whether the chains should be run in parallel or not.}

\item{seeds}{Random seed for each chain. Default is 1:4.}
}
\value{
A \code{fitteddoubleExp} class object containing the original ProbMat class object, posterior of the growth rate, along with its Gelman Rubin statistic and effective sample sizes.
}
\description{
Fits a double exponential growth model to \code{ProbMat} class objects.
}
\details{
The function fits a discrete bounded double exponential growth model on the observed data using MCMC as implemented by the nimble package. The Bayesian model consists of a two growth rate parameters (r1 and r2), with the change from r1 and r2 occurring at inferred point in time eta. Users can define suitable priors using character strings for the argument \code{rPrior1},\code{rPrior2}, and \code{cPrior} (for details on how this should be specified please consult the nimble manual). Please note that the function returns posterior of the growth rate normalised by the resolution defined in the \code{ProbMat} class object.  MCMC settings such as the choice the sampler, number of iterations, chains, etc can also be specified.
}
