% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.banter_model}
\alias{predict,banter_model-method}
\title{Predict BANTER events}
\usage{
predict(object, ...)

\method{predict}{banter_model}(object, new.data, ...)

\S4method{predict}{banter_model}(object, new.data, ...)
}
\arguments{
\item{object}{a \code{\link{banter_model}} object.}

\item{...}{unused.}

\item{new.data}{a list of event and detector data that has the same 
predictors as in the \code{banter_model}. It must contain elements called 
\code{events} and \code{detectors}. The \code{events} element must be a 
data.frame that has a column called \code{event.id} and the same
predictor columns as the event data used to initialize the banter model 
(see \code{\link{initBanterModel}}). The \code{detectors} element must be 
a named list with the same detectors used to build the model 
(see \code{\link{addBanterDetector}}).}
}
\value{
A list with the following elements: \describe{
  \item{events}{the data frame used in the event model for predictions.}
  \item{predict.df}{data.frame of predicted species and assignment 
     probabilities for each event.}
  \item{detector.freq}{data.frame giving the number of events available 
     for each detector.}
  \item{validation.matrix}{if \code{species} is a column in \code{new.data},
     a table giving the classification rate for each event}
}
}
\description{
Predict species of events for novel data from a BANTER model.
}
\note{
At least one detector in the model must be present in \code{new.data}. 
  Any detectors in the training model that are absent will have all species 
  proportions and the the detector propoprtion set to 0. If a column called 
  \code{species} is in \code{new.data}, columns for the original species 
  designation and if that matches predicted (\code{correct}) will be added 
  to the \code{predict.df} data.frame of the output.
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 2, num.cores = 1
)
# run BANTER event model
bant.mdl <- runBanterModel(bant.mdl, ntree = 1000, sampsize = 1)

# predict test data
data(test.data)
test.pred <- predict(bant.mdl, test.data)
test.pred

}
\references{
Rankin, S. , Archer, F. , Keating, J. L., Oswald, J. N., 
  Oswald, M. , Curtis, A. and Barlow, J. (2017), Acoustic classification 
  of dolphins in the California Current using whistles, echolocation clicks, 
  and burst pulses. Marine Mammal Science 33:520-540. doi:10.1111/mms.12381
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
