% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotcompare.R
\name{plotcompare}
\alias{plotcompare}
\title{plotcompare}
\usage{
plotcompare(m1, m2, data, level = 0.95, link1 = "logit", link2 = "logit",
  title = paste("Comparative Predictive Posterior Contours"),
  m1.name = "Model.1", m2.name = "Model.2", group = NULL,
  limits.x = c(0, 1), limits.y = c(0, 1), group.colors = c("blue", "red"))
}
\arguments{
\item{m1}{A model fitted to the data}

\item{m2}{A second model fitted to the data}

\item{data}{The data frame used to fit the model.}

\item{level}{credibility level of the predictive curves}

\item{link1}{The link function used to fit the model m1. Possible values are \emph{logit}, \emph{cloglog} \emph{probit}.}

\item{link2}{The link function used to fit the model m2. Possible values are \emph{logit}, \emph{cloglog} \emph{probit}.}

\item{title}{The title of the plot}

\item{m1.name}{Label of the model 1}

\item{m2.name}{Label of the model 2}

\item{group}{A factor variable to display data of different groups}

\item{limits.x}{A vector with the limits of the horizontal axis}

\item{limits.y}{A vector with the limits of the vertical axis}

\item{group.colors}{A character vector with two color names}
}
\description{
This function compares the predictive posterior surfaces of two fitted models. The current implementation supports only a logistic link function.
}
\examples{
## execute analysis
\dontrun{
# Comparing results from two models same data
data(glas)
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t)
glas.m2 <- metadiag(glas.t, re = "sm")
plotcompare(m1 = glas.m1, m2 = glas.m2)

# Comparing results from two models fitted to two groups of data
# Studies with retrospective design
m1.ct <- metadiag(ct[ct$design==1, 1:4])

# Studies with prospective design
m1.ct <- metadiag(ct[ct$design==1, 1:4])

plotcompare(m1.ct, m2.ct, data = ct,
           m1.name = "Retrospective design", m2.name = "Prospective design",
             group = factor(ct$design),
             limits.x = c(0, 0.75), limits.y = c(0.65, 1))
}
}
\seealso{
\code{\link{metadiag}}.
}
\keyword{file}

