% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbp.R
\name{sbp.fromPropd}
\alias{sbp.fromPropd}
\title{Build SBP Matrix of "Anti-Principal Discriminant Balances"}
\usage{
sbp.fromPropd(x, group, ...)
}
\arguments{
\item{x}{A matrix with rows as samples (N) and columns as components (D).}

\item{group}{A character vector. Group or sub-group membership.
Argument passed to \code{propr::propd}.}

\item{...}{Other arguments passed to \code{propr::propd}.}
}
\value{
An SBP matrix.
}
\description{
A wrapper for \code{\link{sbp.fromADBA}}.
 See also \code{\link{sbp.fromPDBA}}.
}
\examples{
\dontrun{
library(balance)
data(iris)
x <- iris[1:100,1:4]
y <- iris[1:100,5]
sbp.fromPropd(x, y)
}

}
\author{
Thom Quinn
}
