% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-model.R
\name{write_model_NoReg}
\alias{write_model_NoReg}
\title{Write .bug model file for model without regression}
\usage{
write_model_NoReg(
  k_subclass,
  Mobs,
  prior,
  cause_list,
  use_measurements,
  ppd = NULL,
  use_jags = FALSE
)
}
\arguments{
\item{k_subclass}{the number of subclasses for the slices that require
conditional dependence modeling (only applicable to BrS data); its length is
of the same value as the number of BrS slices.}

\item{Mobs}{measurement data in the form of \code{data_nplcm}}

\item{prior}{prior specification from \code{model_options}}

\item{cause_list}{a list of latent status names (crucial for building templates;
see \code{\link[=make_template]{make_template()}})}

\item{use_measurements}{"BrS", or "SS"}

\item{ppd}{Default is NULL; set to TRUE for posterior predictive checking}

\item{use_jags}{Default is FALSE; set to TRUE if want to use JAGS for model fitting.}
}
\value{
a long character string to be written into .bug file.
}
\description{
\code{write_model_NoReg} automatically generates model file according to
\code{model_options}
}
\seealso{
\link{insert_bugfile_chunk_noreg_meas} for inserting .bug file
chunk for measurements (plug-and-play); \link{insert_bugfile_chunk_noreg_etiology}
for inserting .bug file chunk for distribution of latent status (etiology).

Other model generation functions: 
\code{\link{write_model_Reg_Nest}()},
\code{\link{write_model_Reg_NoNest}()},
\code{\link{write_model_Reg_discrete_predictor_NoNest}()}
}
\concept{model generation functions}
