% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\name{gen_outlier}
\alias{gen_outlier}
\title{generate outliers from a series of number}
\usage{
gen_outlier(
  x,
  n,
  digits = 0,
  side = "both",
  lim = NULL,
  assign_n = NULL,
  only_out = TRUE
)
}
\arguments{
\item{x}{number vector}

\item{n}{number of outliers to generate}

\item{digits}{the digits of outliers}

\item{side}{should be one of \verb{both, low, high}}

\item{lim}{a two-length vector to assign the limitations of the outliers
if method is \code{both}, the outliers will be limited in
[lim[1], low_outlier_threshold] and [high_outlier_threshold, lim[2]]
;
if method is \code{low}, the outliers will be limited in
[lim[1], min(low_outlier_threshold, lim[2])]
;
if method is \code{high}, the outliers will be limited in
[max(high_outlier_threshold, lim[1]), lim[2]]}

\item{assign_n}{manually assign the number of low outliers or
high outliers when method is \code{both}}

\item{only_out}{only return outliers}
}
\value{
number vector of outliers
}
\description{
generate outliers from a series of number
}
\examples{
x <- seq(0, 100, 1)

gen_outlier(x, 10)

# generation limits
gen_outlier(x, 10, lim = c(-80, 160))

# assign the low and high outliers
gen_outlier(x, 10, lim = c(-80, 160), assign_n = c(0.1, 0.9))

# just generate low outliers
gen_outlier(x, 10, side = "low")

# return with raw vector
gen_outlier(x, 10, only_out = FALSE)

}
