% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irc.R
\name{irc.bairt}
\alias{irc.bairt}
\title{Plot of posterior density of the item response curve}
\usage{
\method{irc}{bairt}(mcmclist, item = 1, color = "red", prob = c(0.05,
  0.95), ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{item}{The number of \emph{j-th} item.}

\item{color}{Item response curve color.}

\item{prob}{A vector of length two for defined the percentiles of the
posterior density.}

\item{...}{Further arguments.}
}
\value{
Plot of the \emph{j-th} \code{item} response curve.
}
\description{
Plot of the \emph{j-th} \code{item} response curve.
}
\details{
The solid line corresponds to the location of the posterior mean and the
points correspond to the percentiles determined by \emph{prob}.
\emph{prob = c(0.05, 0.95)} corresponds to the 5th and 95th percentils of
the posterior density respectively.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 400, burning = 100)
check.plot(model2)
irc(model2, item = 3)

\donttest{
# For all examinees of the data MathTest
# Three-Parameter Normal Ogive Model
# selection of the prior for 5 response options
cprior <- select.c.prior(5)
modelAll3 <- mcmc.3pnob(MathTest, iter = 1000, burning = 0,
                    c.prior = cprior)
irc(modelAll3 , item = 1, color = "blue")
irc(modelAll3 , item = 1, color = "blue", prob = c(0.1, 0.9))
}

## End(Not run)


}
\references{
Johnson, V. E. & Albert, J. H. (1999). Ordinal Data Modeling.
New York: Springer.
}
\seealso{
\code{\link{mcmc.2pnob}}, \code{\link{mcmc.3pnob}} and
\code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
