% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_cost.R
\name{class_cost}
\alias{class_cost}
\title{Cost parameter for minority class}
\usage{
class_cost(range = c(0, 5), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Used in \code{bag_treer()}.
}
\details{
This parameter reflects the cost of a misclassified sample relative to a
baseline cost of 1.0. For example, if the first level of an outcome factor
occurred rarely, it might help if this parameter were set to values greater
than 1.0. If the second level of the outcome factor is in the minority,
values less than 1.0 would cause the model to emphasize the minority class
more than the majority class.
}
\examples{
class_cost()
}
