// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_rubin_full_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 66, column 2 to column 42)",
                                                      " (in 'string', line 67, column 2 to column 29)",
                                                      " (in 'string', line 68, column 2 to column 52)",
                                                      " (in 'string', line 69, column 2 to column 39)",
                                                      " (in 'string', line 70, column 2 to column 23)",
                                                      " (in 'string', line 71, column 2 to column 36)",
                                                      " (in 'string', line 72, column 2 to column 18)",
                                                      " (in 'string', line 74, column 2 to column 31)",
                                                      " (in 'string', line 77, column 2 to column 27)",
                                                      " (in 'string', line 78, column 2 to column 23)",
                                                      " (in 'string', line 82, column 4 to column 55)",
                                                      " (in 'string', line 81, column 7 to line 82, column 55)",
                                                      " (in 'string', line 80, column 4 to column 18)",
                                                      " (in 'string', line 79, column 2 to line 82, column 55)",
                                                      " (in 'string', line 88, column 4 to column 36)",
                                                      " (in 'string', line 86, column 4 to column 78)",
                                                      " (in 'string', line 85, column 7 to line 88, column 36)",
                                                      " (in 'string', line 84, column 4 to column 30)",
                                                      " (in 'string', line 83, column 2 to line 88, column 36)",
                                                      " (in 'string', line 128, column 2 to column 25)",
                                                      " (in 'string', line 129, column 2 to column 25)",
                                                      " (in 'string', line 134, column 6 to column 28)",
                                                      " (in 'string', line 132, column 6 to column 40)",
                                                      " (in 'string', line 131, column 4 to line 134, column 28)",
                                                      " (in 'string', line 135, column 4 to column 17)",
                                                      " (in 'string', line 138, column 8 to line 139, column 81)",
                                                      " (in 'string', line 137, column 6 to line 139, column 81)",
                                                      " (in 'string', line 141, column 8 to line 142, column 70)",
                                                      " (in 'string', line 140, column 6 to line 142, column 70)",
                                                      " (in 'string', line 136, column 22 to line 143, column 5)",
                                                      " (in 'string', line 136, column 4 to line 143, column 5)",
                                                      " (in 'string', line 130, column 16 to line 144, column 3)",
                                                      " (in 'string', line 130, column 2 to line 144, column 3)",
                                                      " (in 'string', line 92, column 9 to column 10)",
                                                      " (in 'string', line 92, column 2 to column 15)",
                                                      " (in 'string', line 97, column 6 to column 18)",
                                                      " (in 'string', line 98, column 6 to column 54)",
                                                      " (in 'string', line 96, column 11 to line 99, column 5)",
                                                      " (in 'string', line 95, column 6 to column 30)",
                                                      " (in 'string', line 94, column 15 to line 96, column 5)",
                                                      " (in 'string', line 94, column 4 to line 99, column 5)",
                                                      " (in 'string', line 93, column 11 to line 100, column 3)",
                                                      " (in 'string', line 93, column 2 to line 100, column 3)",
                                                      " (in 'string', line 105, column 4 to column 31)",
                                                      " (in 'string', line 106, column 4 to column 70)",
                                                      " (in 'string', line 107, column 4 to column 76)",
                                                      " (in 'string', line 104, column 32 to line 108, column 3)",
                                                      " (in 'string', line 104, column 7 to line 108, column 3)",
                                                      " (in 'string', line 103, column 4 to column 66)",
                                                      " (in 'string', line 102, column 2 to line 108, column 3)",
                                                      " (in 'string', line 119, column 4 to column 64)",
                                                      " (in 'string', line 120, column 4 to column 75)",
                                                      " (in 'string', line 118, column 9 to line 121, column 3)",
                                                      " (in 'string', line 114, column 4 to column 22)",
                                                      " (in 'string', line 115, column 4 to column 61)",
                                                      " (in 'string', line 116, column 4 to column 64)",
                                                      " (in 'string', line 117, column 4 to column 84)",
                                                      " (in 'string', line 113, column 30 to line 118, column 3)",
                                                      " (in 'string', line 113, column 9 to line 121, column 3)",
                                                      " (in 'string', line 111, column 4 to column 61)",
                                                      " (in 'string', line 112, column 4 to column 84)",
                                                      " (in 'string', line 110, column 23 to line 113, column 3)",
                                                      " (in 'string', line 110, column 2 to line 121, column 3)",
                                                      " (in 'string', line 123, column 2 to column 57)",
                                                      " (in 'string', line 25, column 2 to column 17)",
                                                      " (in 'string', line 26, column 2 to column 17)",
                                                      " (in 'string', line 27, column 2 to column 18)",
                                                      " (in 'string', line 28, column 9 to column 10)",
                                                      " (in 'string', line 28, column 11 to column 13)",
                                                      " (in 'string', line 28, column 2 to column 17)",
                                                      " (in 'string', line 29, column 2 to column 19)",
                                                      " (in 'string', line 30, column 2 to column 23)",
                                                      " (in 'string', line 32, column 28 to column 29)",
                                                      " (in 'string', line 32, column 2 to column 31)",
                                                      " (in 'string', line 33, column 26 to column 27)",
                                                      " (in 'string', line 33, column 2 to column 39)",
                                                      " (in 'string', line 35, column 2 to column 24)",
                                                      " (in 'string', line 36, column 2 to column 27)",
                                                      " (in 'string', line 37, column 2 to column 30)",
                                                      " (in 'string', line 38, column 2 to column 33)",
                                                      " (in 'string', line 40, column 2 to column 26)",
                                                      " (in 'string', line 41, column 2 to column 24)",
                                                      " (in 'string', line 42, column 2 to column 21)",
                                                      " (in 'string', line 43, column 2 to column 32)",
                                                      " (in 'string', line 44, column 2 to column 30)",
                                                      " (in 'string', line 45, column 2 to column 27)",
                                                      " (in 'string', line 47, column 2 to column 22)",
                                                      " (in 'string', line 48, column 2 to column 28)",
                                                      " (in 'string', line 50, column 2 to column 22)",
                                                      " (in 'string', line 51, column 2 to column 22)",
                                                      " (in 'string', line 52, column 9 to column 15)",
                                                      " (in 'string', line 52, column 17 to column 19)",
                                                      " (in 'string', line 52, column 2 to column 28)",
                                                      " (in 'string', line 53, column 34 to column 40)",
                                                      " (in 'string', line 53, column 2 to column 42)",
                                                      " (in 'string', line 54, column 39 to column 45)",
                                                      " (in 'string', line 54, column 2 to column 47)",
                                                      " (in 'string', line 56, column 9 to column 10)",
                                                      " (in 'string', line 56, column 2 to column 12)",
                                                      " (in 'string', line 57, column 14 to column 20)",
                                                      " (in 'string', line 57, column 2 to column 22)",
                                                      " (in 'string', line 58, column 22 to column 28)",
                                                      " (in 'string', line 58, column 2 to column 30)",
                                                      " (in 'string', line 61, column 2 to column 43)",
                                                      " (in 'string', line 62, column 2 to column 51)",
                                                      " (in 'string', line 66, column 19 to column 40)",
                                                      " (in 'string', line 67, column 10 to column 27)",
                                                      " (in 'string', line 68, column 29 to column 50)",
                                                      " (in 'string', line 69, column 20 to column 37)",
                                                      " (in 'string', line 70, column 9 to column 17)",
                                                      " (in 'string', line 71, column 9 to column 21)",
                                                      " (in 'string', line 72, column 9 to column 11)",
                                                      " (in 'string', line 74, column 18 to column 19)",
                                                      " (in 'string', line 77, column 9 to column 17)",
                                                      " (in 'string', line 78, column 9 to column 10)",
                                                      " (in 'string', line 128, column 13 to column 23)",
                                                      " (in 'string', line 129, column 9 to column 15)",
                                                      " (in 'string', line 11, column 9 to column 66)",
                                                      " (in 'string', line 9, column 25 to column 73)",
                                                      " (in 'string', line 9, column 9 to line 11, column 66)",
                                                      " (in 'string', line 6, column 25 to column 70)",
                                                      " (in 'string', line 6, column 9 to line 11, column 66)",
                                                      " (in 'string', line 5, column 25 to column 70)",
                                                      " (in 'string', line 5, column 9 to line 11, column 66)",
                                                      " (in 'string', line 4, column 20 to column 66)",
                                                      " (in 'string', line 4, column 4 to line 11, column 66)",
                                                      " (in 'string', line 3, column 60 to line 12, column 3)",
                                                      " (in 'string', line 20, column 9 to column 66)",
                                                      " (in 'string', line 18, column 25 to column 73)",
                                                      " (in 'string', line 18, column 9 to line 20, column 66)",
                                                      " (in 'string', line 17, column 25 to column 70)",
                                                      " (in 'string', line 17, column 9 to line 20, column 66)",
                                                      " (in 'string', line 16, column 25 to column 70)",
                                                      " (in 'string', line 16, column 9 to line 20, column 66)",
                                                      " (in 'string', line 15, column 20 to column 66)",
                                                      " (in 'string', line 15, column 4 to line 20, column 66)",
                                                      " (in 'string', line 14, column 61 to line 21, column 3)"};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T2__>>;
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 126;
    if (logical_eq(family, 0)) {
      current_statement__ = 125;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 124;
      if (logical_eq(family, 1)) {
        current_statement__ = 123;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 122;
        if (logical_eq(family, 2)) {
          current_statement__ = 121;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 120;
          if (logical_eq(family, 5)) {
            current_statement__ = 119;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 118;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct realprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return realprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family,
              const T2__& pars_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>>;
  const auto& theta = to_ref(theta_arg__);
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 136;
    if (logical_eq(family, 0)) {
      current_statement__ = 135;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 134;
      if (logical_eq(family, 1)) {
        current_statement__ = 133;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 132;
        if (logical_eq(family, 2)) {
          current_statement__ = 131;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 130;
          if (logical_eq(family, 5)) {
            current_statement__ = 129;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 128;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct vecprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return vecprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_rubin_full final : public model_base_crtp<model_rubin_full> {
private:
  int N;
  int K;
  int Nc;
  Eigen::Matrix<double, -1, -1> X;
  int pooling_type;
  int pooling_baseline;
  std::vector<int> site;
  Eigen::Matrix<double, -1, 1> treatment;
  int prior_control_fam;
  int prior_control_sd_fam;
  Eigen::Matrix<double, -1, 1> prior_control_val;
  Eigen::Matrix<double, -1, 1> prior_control_sd_val;
  int prior_hypermean_fam;
  int prior_hypersd_fam;
  int prior_beta_fam;
  Eigen::Matrix<double, -1, 1> prior_hypermean_val;
  Eigen::Matrix<double, -1, 1> prior_hypersd_val;
  Eigen::Matrix<double, -1, 1> prior_beta_val;
  int prior_sigma_fam;
  Eigen::Matrix<double, -1, 1> prior_sigma_val;
  int N_test;
  int K_test;
  Eigen::Matrix<double, -1, -1> X_test;
  std::vector<int> test_site;
  std::vector<int> test_treatment;
  std::vector<double> y;
  std::vector<double> test_y;
  std::vector<double> test_sigma_y_k;
  int K_pooled;
  int K_bsl_pooled;
  int mu_baseline_1dim__;
  int mu_1dim__;
  int tau_baseline_1dim__;
  int tau_1dim__;
  int logpd_1dim__;
 
public:
  ~model_rubin_full() { }
  
  inline std::string model_name() const final { return "model_rubin_full"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_rubin_full(stan::io::var_context& context__,
                   unsigned int random_seed__ = 0,
                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_rubin_full_namespace::model_rubin_full";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 65;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization","Nc","int",
          context__.to_vec());
      Nc = std::numeric_limits<int>::min();
      
      current_statement__ = 67;
      Nc = context__.vals_i("Nc")[(1 - 1)];
      current_statement__ = 67;
      current_statement__ = 67;
      check_greater_or_equal(function__, "Nc", Nc, 0);
      current_statement__ = 68;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 69;
      validate_non_negative_index("X", "Nc", Nc);
      current_statement__ = 70;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, Nc));
      X = Eigen::Matrix<double, -1, -1>(N, Nc);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 70;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 70;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 70;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 70;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 71;
      context__.validate_dims("data initialization","pooling_type","int",
          context__.to_vec());
      pooling_type = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      pooling_type = context__.vals_i("pooling_type")[(1 - 1)];
      current_statement__ = 72;
      context__.validate_dims("data initialization","pooling_baseline","int",
          context__.to_vec());
      pooling_baseline = std::numeric_limits<int>::min();
      
      current_statement__ = 72;
      pooling_baseline = context__.vals_i("pooling_baseline")[(1 - 1)];
      current_statement__ = 73;
      validate_non_negative_index("site", "N", N);
      current_statement__ = 74;
      context__.validate_dims("data initialization","site","int",
          context__.to_vec(N));
      site = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 74;
      assign(site, nil_index_list(), context__.vals_i("site"),
        "assigning variable site");
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_greater_or_equal(function__, "site[sym1__]",
                               site[(sym1__ - 1)], 0);}
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_less_or_equal(function__, "site[sym1__]", site[(sym1__ - 1)], K);
      }
      current_statement__ = 75;
      validate_non_negative_index("treatment", "N", N);
      current_statement__ = 76;
      context__.validate_dims("data initialization","treatment","double",
          context__.to_vec(N));
      treatment = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(treatment, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> treatment_flat__;
        current_statement__ = 76;
        assign(treatment_flat__, nil_index_list(),
          context__.vals_r("treatment"),
          "assigning variable treatment_flat__");
        current_statement__ = 76;
        pos__ = 1;
        current_statement__ = 76;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 76;
          assign(treatment, cons_list(index_uni(sym1__), nil_index_list()),
            treatment_flat__[(pos__ - 1)], "assigning variable treatment");
          current_statement__ = 76;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 76;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 76;
        current_statement__ = 76;
        check_greater_or_equal(function__, "treatment[sym1__]",
                               treatment[(sym1__ - 1)], 0);}
      current_statement__ = 76;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 76;
        current_statement__ = 76;
        check_less_or_equal(function__, "treatment[sym1__]",
                            treatment[(sym1__ - 1)], 1);}
      current_statement__ = 77;
      context__.validate_dims("data initialization","prior_control_fam",
          "int",context__.to_vec());
      prior_control_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 77;
      prior_control_fam = context__.vals_i("prior_control_fam")[(1 - 1)];
      current_statement__ = 78;
      context__.validate_dims("data initialization","prior_control_sd_fam",
          "int",context__.to_vec());
      prior_control_sd_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 78;
      prior_control_sd_fam = context__.vals_i("prior_control_sd_fam")[
          (1 - 1)];
      current_statement__ = 79;
      context__.validate_dims("data initialization","prior_control_val",
          "double",context__.to_vec(3));
      prior_control_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_control_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_control_val_flat__;
        current_statement__ = 79;
        assign(prior_control_val_flat__, nil_index_list(),
          context__.vals_r("prior_control_val"),
          "assigning variable prior_control_val_flat__");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 79;
          assign(prior_control_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_control_val_flat__[(pos__ - 1)],
            "assigning variable prior_control_val");
          current_statement__ = 79;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 80;
      context__.validate_dims("data initialization","prior_control_sd_val",
          "double",context__.to_vec(3));
      prior_control_sd_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_control_sd_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_control_sd_val_flat__;
        current_statement__ = 80;
        assign(prior_control_sd_val_flat__, nil_index_list(),
          context__.vals_r("prior_control_sd_val"),
          "assigning variable prior_control_sd_val_flat__");
        current_statement__ = 80;
        pos__ = 1;
        current_statement__ = 80;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 80;
          assign(prior_control_sd_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_control_sd_val_flat__[(pos__ - 1)],
            "assigning variable prior_control_sd_val");
          current_statement__ = 80;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 81;
      context__.validate_dims("data initialization","prior_hypermean_fam",
          "int",context__.to_vec());
      prior_hypermean_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 81;
      prior_hypermean_fam = context__.vals_i("prior_hypermean_fam")[(1 - 1)];
      current_statement__ = 82;
      context__.validate_dims("data initialization","prior_hypersd_fam",
          "int",context__.to_vec());
      prior_hypersd_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 82;
      prior_hypersd_fam = context__.vals_i("prior_hypersd_fam")[(1 - 1)];
      current_statement__ = 83;
      context__.validate_dims("data initialization","prior_beta_fam","int",
          context__.to_vec());
      prior_beta_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 83;
      prior_beta_fam = context__.vals_i("prior_beta_fam")[(1 - 1)];
      current_statement__ = 84;
      context__.validate_dims("data initialization","prior_hypermean_val",
          "double",context__.to_vec(3));
      prior_hypermean_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_hypermean_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypermean_val_flat__;
        current_statement__ = 84;
        assign(prior_hypermean_val_flat__, nil_index_list(),
          context__.vals_r("prior_hypermean_val"),
          "assigning variable prior_hypermean_val_flat__");
        current_statement__ = 84;
        pos__ = 1;
        current_statement__ = 84;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 84;
          assign(prior_hypermean_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypermean_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypermean_val");
          current_statement__ = 84;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 85;
      context__.validate_dims("data initialization","prior_hypersd_val",
          "double",context__.to_vec(3));
      prior_hypersd_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_hypersd_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypersd_val_flat__;
        current_statement__ = 85;
        assign(prior_hypersd_val_flat__, nil_index_list(),
          context__.vals_r("prior_hypersd_val"),
          "assigning variable prior_hypersd_val_flat__");
        current_statement__ = 85;
        pos__ = 1;
        current_statement__ = 85;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 85;
          assign(prior_hypersd_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypersd_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypersd_val");
          current_statement__ = 85;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 86;
      context__.validate_dims("data initialization","prior_beta_val",
          "double",context__.to_vec(3));
      prior_beta_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_beta_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_beta_val_flat__;
        current_statement__ = 86;
        assign(prior_beta_val_flat__, nil_index_list(),
          context__.vals_r("prior_beta_val"),
          "assigning variable prior_beta_val_flat__");
        current_statement__ = 86;
        pos__ = 1;
        current_statement__ = 86;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 86;
          assign(prior_beta_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_beta_val_flat__[(pos__ - 1)],
            "assigning variable prior_beta_val");
          current_statement__ = 86;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 87;
      context__.validate_dims("data initialization","prior_sigma_fam","int",
          context__.to_vec());
      prior_sigma_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 87;
      prior_sigma_fam = context__.vals_i("prior_sigma_fam")[(1 - 1)];
      current_statement__ = 88;
      context__.validate_dims("data initialization","prior_sigma_val",
          "double",context__.to_vec(3));
      prior_sigma_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_sigma_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_sigma_val_flat__;
        current_statement__ = 88;
        assign(prior_sigma_val_flat__, nil_index_list(),
          context__.vals_r("prior_sigma_val"),
          "assigning variable prior_sigma_val_flat__");
        current_statement__ = 88;
        pos__ = 1;
        current_statement__ = 88;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 88;
          assign(prior_sigma_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_sigma_val_flat__[(pos__ - 1)],
            "assigning variable prior_sigma_val");
          current_statement__ = 88;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 89;
      context__.validate_dims("data initialization","N_test","int",
          context__.to_vec());
      N_test = std::numeric_limits<int>::min();
      
      current_statement__ = 89;
      N_test = context__.vals_i("N_test")[(1 - 1)];
      current_statement__ = 89;
      current_statement__ = 89;
      check_greater_or_equal(function__, "N_test", N_test, 0);
      current_statement__ = 90;
      context__.validate_dims("data initialization","K_test","int",
          context__.to_vec());
      K_test = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      K_test = context__.vals_i("K_test")[(1 - 1)];
      current_statement__ = 90;
      current_statement__ = 90;
      check_greater_or_equal(function__, "K_test", K_test, 0);
      current_statement__ = 91;
      validate_non_negative_index("X_test", "N_test", N_test);
      current_statement__ = 92;
      validate_non_negative_index("X_test", "Nc", Nc);
      current_statement__ = 93;
      context__.validate_dims("data initialization","X_test","double",
          context__.to_vec(N_test, Nc));
      X_test = Eigen::Matrix<double, -1, -1>(N_test, Nc);
      stan::math::fill(X_test, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_test_flat__;
        current_statement__ = 93;
        assign(X_test_flat__, nil_index_list(), context__.vals_r("X_test"),
          "assigning variable X_test_flat__");
        current_statement__ = 93;
        pos__ = 1;
        current_statement__ = 93;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 93;
          for (int sym2__ = 1; sym2__ <= N_test; ++sym2__) {
            current_statement__ = 93;
            assign(X_test,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_test_flat__[(pos__ - 1)], "assigning variable X_test");
            current_statement__ = 93;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 94;
      validate_non_negative_index("test_site", "N_test", N_test);
      current_statement__ = 95;
      context__.validate_dims("data initialization","test_site","int",
          context__.to_vec(N_test));
      test_site = std::vector<int>(N_test, std::numeric_limits<int>::min());
      
      current_statement__ = 95;
      assign(test_site, nil_index_list(), context__.vals_i("test_site"),
        "assigning variable test_site");
      current_statement__ = 95;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 95;
        current_statement__ = 95;
        check_greater_or_equal(function__, "test_site[sym1__]",
                               test_site[(sym1__ - 1)], 0);}
      current_statement__ = 95;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 95;
        current_statement__ = 95;
        check_less_or_equal(function__, "test_site[sym1__]",
                            test_site[(sym1__ - 1)], K);}
      current_statement__ = 96;
      validate_non_negative_index("test_treatment", "N_test", N_test);
      current_statement__ = 97;
      context__.validate_dims("data initialization","test_treatment","int",
          context__.to_vec(N_test));
      test_treatment = std::vector<int>(N_test, std::numeric_limits<int>::min());
      
      current_statement__ = 97;
      assign(test_treatment, nil_index_list(),
        context__.vals_i("test_treatment"),
        "assigning variable test_treatment");
      current_statement__ = 97;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 97;
        current_statement__ = 97;
        check_greater_or_equal(function__, "test_treatment[sym1__]",
                               test_treatment[(sym1__ - 1)], 0);}
      current_statement__ = 97;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 97;
        current_statement__ = 97;
        check_less_or_equal(function__, "test_treatment[sym1__]",
                            test_treatment[(sym1__ - 1)], 1);}
      current_statement__ = 98;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 99;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 99;
      assign(y, nil_index_list(), context__.vals_r("y"),
        "assigning variable y");
      current_statement__ = 100;
      validate_non_negative_index("test_y", "N_test", N_test);
      current_statement__ = 101;
      context__.validate_dims("data initialization","test_y","double",
          context__.to_vec(N_test));
      test_y = std::vector<double>(N_test, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 101;
      assign(test_y, nil_index_list(), context__.vals_r("test_y"),
        "assigning variable test_y");
      current_statement__ = 102;
      validate_non_negative_index("test_sigma_y_k", "K_test", K_test);
      current_statement__ = 103;
      context__.validate_dims("data initialization","test_sigma_y_k",
          "double",context__.to_vec(K_test));
      test_sigma_y_k = std::vector<double>(K_test, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 103;
      assign(test_sigma_y_k, nil_index_list(),
        context__.vals_r("test_sigma_y_k"),
        "assigning variable test_sigma_y_k");
      current_statement__ = 104;
      K_pooled = std::numeric_limits<int>::min();
      
      current_statement__ = 104;
      K_pooled = (logical_eq(pooling_type, 2) ? 0 : K);
      current_statement__ = 105;
      K_bsl_pooled = std::numeric_limits<int>::min();
      
      current_statement__ = 105;
      K_bsl_pooled = (logical_eq(pooling_baseline, 2) ? 0 : K);
      current_statement__ = 106;
      mu_baseline_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 106;
      mu_baseline_1dim__ = logical_eq(pooling_baseline, 1);
      current_statement__ = 106;
      validate_non_negative_index("mu_baseline", "pooling_baseline == 1",
                                  mu_baseline_1dim__);
      current_statement__ = 107;
      mu_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 107;
      mu_1dim__ = logical_neq(pooling_type, 0);
      current_statement__ = 107;
      validate_non_negative_index("mu", "pooling_type != 0", mu_1dim__);
      current_statement__ = 108;
      tau_baseline_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 108;
      tau_baseline_1dim__ = logical_eq(pooling_baseline, 1);
      current_statement__ = 108;
      validate_non_negative_index("tau_baseline", "pooling_baseline == 1",
                                  tau_baseline_1dim__);
      current_statement__ = 109;
      tau_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 109;
      tau_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 109;
      validate_non_negative_index("tau", "pooling_type == 1", tau_1dim__);
      current_statement__ = 110;
      validate_non_negative_index("eta", "K_pooled", K_pooled);
      current_statement__ = 111;
      validate_non_negative_index("eta_baseline", "K_bsl_pooled",
                                  K_bsl_pooled);
      current_statement__ = 112;
      validate_non_negative_index("beta", "Nc", Nc);
      current_statement__ = 113;
      validate_non_negative_index("sigma_y_k", "K", K);
      current_statement__ = 114;
      validate_non_negative_index("theta_k", "K_pooled", K_pooled);
      current_statement__ = 115;
      validate_non_negative_index("baseline_k", "K", K);
      current_statement__ = 116;
      logpd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 116;
      logpd_1dim__ = logical_gt(K_test, 0);
      current_statement__ = 116;
      validate_non_negative_index("logpd", "K_test > 0", logpd_1dim__);
      current_statement__ = 117;
      validate_non_negative_index("fe_test", "N_test", N_test);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += mu_baseline_1dim__;
      num_params_r__ += mu_1dim__;
      num_params_r__ += tau_baseline_1dim__;
      num_params_r__ += tau_1dim__;
      num_params_r__ += K_pooled;
      num_params_r__ += K_bsl_pooled;
      num_params_r__ += Nc;
      num_params_r__ += K;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_rubin_full_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> mu_baseline;
      mu_baseline = std::vector<local_scalar_t__>(mu_baseline_1dim__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= mu_baseline_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(mu_baseline, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu_baseline");}
      std::vector<local_scalar_t__> mu;
      mu = std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<local_scalar_t__> tau_baseline;
      tau_baseline = std::vector<local_scalar_t__>(tau_baseline_1dim__, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(tau_baseline, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable tau_baseline");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(tau_baseline,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau_baseline[(sym1__ - 1)], 0, lp__),
            "assigning variable tau_baseline");
        } else {
          current_statement__ = 3;
          assign(tau_baseline,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau_baseline[(sym1__ - 1)], 0),
            "assigning variable tau_baseline");
        }}
      std::vector<local_scalar_t__> tau;
      tau = std::vector<local_scalar_t__>(tau_1dim__, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable tau");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau[(sym1__ - 1)], 0, lp__),
            "assigning variable tau");
        } else {
          current_statement__ = 4;
          assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau[(sym1__ - 1)], 0),
            "assigning variable tau");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> eta;
      eta = Eigen::Matrix<local_scalar_t__, -1, 1>(K_pooled);
      stan::math::fill(eta, DUMMY_VAR__);
      
      current_statement__ = 5;
      eta = in__.vector(K_pooled);
      Eigen::Matrix<local_scalar_t__, -1, 1> eta_baseline;
      eta_baseline = Eigen::Matrix<local_scalar_t__, -1, 1>(K_bsl_pooled);
      stan::math::fill(eta_baseline, DUMMY_VAR__);
      
      current_statement__ = 6;
      eta_baseline = in__.vector(K_bsl_pooled);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(Nc);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 7;
      beta = in__.vector(Nc);
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma_y_k;
      sigma_y_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(sigma_y_k, DUMMY_VAR__);
      
      current_statement__ = 8;
      sigma_y_k = in__.vector(K);
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 8;
        if (jacobian__) {
          current_statement__ = 8;
          assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_y_k[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_y_k");
        } else {
          current_statement__ = 8;
          assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_y_k[(sym1__ - 1)], 0),
            "assigning variable sigma_y_k");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> theta_k;
      theta_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K_pooled);
      stan::math::fill(theta_k, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> baseline_k;
      baseline_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(baseline_k, DUMMY_VAR__);
      
      current_statement__ = 14;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 13;
        assign(theta_k, nil_index_list(), eta, "assigning variable theta_k");
      } else {
        current_statement__ = 12;
        if (logical_eq(pooling_type, 1)) {
          current_statement__ = 11;
          assign(theta_k, nil_index_list(),
            add(rep_vector(mu[(1 - 1)], K_pooled),
              multiply(tau[(1 - 1)], eta)), "assigning variable theta_k");
        } 
      }
      current_statement__ = 19;
      if (logical_eq(pooling_baseline, 0)) {
        current_statement__ = 18;
        assign(baseline_k, nil_index_list(), eta_baseline,
          "assigning variable baseline_k");
      } else {
        current_statement__ = 17;
        if (logical_eq(pooling_baseline, 1)) {
          current_statement__ = 16;
          assign(baseline_k, nil_index_list(),
            add(rep_vector(mu_baseline[(1 - 1)], K),
              multiply(tau_baseline[(1 - 1)], eta_baseline)),
            "assigning variable baseline_k");
        } else {
          current_statement__ = 15;
          assign(baseline_k, nil_index_list(), rep_vector(0.0, K),
            "assigning variable baseline_k");
        }
      }
      {
        current_statement__ = 34;
        validate_non_negative_index("fe", "N", N);
        Eigen::Matrix<local_scalar_t__, -1, 1> fe;
        fe = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
        stan::math::fill(fe, DUMMY_VAR__);
        
        current_statement__ = 43;
        if (logical_gt(N, 0)) {
          current_statement__ = 41;
          if (logical_eq(Nc, 0)) {
            current_statement__ = 39;
            assign(fe, nil_index_list(), rep_vector(0.0, N),
              "assigning variable fe");
          } else {
            current_statement__ = 36;
            assign(fe, nil_index_list(), multiply(X, beta),
              "assigning variable fe");
            current_statement__ = 37;
            lp_accum__.add(
              vecprior_lpdf<propto__>(beta, prior_beta_fam,
                prior_beta_val, pstream__));
          }
        } 
        current_statement__ = 50;
        if (logical_eq(pooling_baseline, 0)) {
          current_statement__ = 49;
          lp_accum__.add(
            vecprior_lpdf<propto__>(eta_baseline, prior_control_fam,
              prior_control_val, pstream__));
        } else {
          current_statement__ = 48;
          if (logical_eq(pooling_baseline, 1)) {
            current_statement__ = 44;
            lp_accum__.add(normal_lpdf<propto__>(eta_baseline, 0, 1));
            current_statement__ = 45;
            lp_accum__.add(
              realprior_lpdf<propto__>(mu_baseline[(1 - 1)],
                prior_control_fam, prior_control_val, pstream__));
            current_statement__ = 46;
            lp_accum__.add(
              realprior_lpdf<propto__>(tau_baseline[(1 - 1)],
                prior_control_sd_fam, prior_control_sd_val, pstream__));
          } 
        }
        current_statement__ = 63;
        if (logical_eq(pooling_type, 0)) {
          current_statement__ = 60;
          lp_accum__.add(
            vecprior_lpdf<propto__>(eta, prior_hypermean_fam,
              prior_hypermean_val, pstream__));
          current_statement__ = 61;
          lp_accum__.add(
            normal_lpdf<propto__>(y,
              add(
                add(
                  rvalue(baseline_k,
                    cons_list(index_multi(site), nil_index_list()),
                    "baseline_k"),
                  elt_multiply(
                    rvalue(theta_k,
                      cons_list(index_multi(site), nil_index_list()),
                      "theta_k"), treatment)), fe),
              rvalue(sigma_y_k,
                cons_list(index_multi(site), nil_index_list()), "sigma_y_k")));
        } else {
          current_statement__ = 59;
          if (logical_eq(pooling_type, 1)) {
            current_statement__ = 54;
            lp_accum__.add(normal_lpdf<propto__>(eta, 0, 1));
            current_statement__ = 55;
            lp_accum__.add(
              realprior_lpdf<propto__>(tau[(1 - 1)], prior_hypersd_fam,
                prior_hypersd_val, pstream__));
            current_statement__ = 56;
            lp_accum__.add(
              realprior_lpdf<propto__>(mu[(1 - 1)], prior_hypermean_fam,
                prior_hypermean_val, pstream__));
            current_statement__ = 57;
            lp_accum__.add(
              normal_lpdf<propto__>(y,
                add(
                  add(
                    rvalue(baseline_k,
                      cons_list(index_multi(site), nil_index_list()),
                      "baseline_k"),
                    elt_multiply(
                      rvalue(theta_k,
                        cons_list(index_multi(site), nil_index_list()),
                        "theta_k"), treatment)), fe),
                rvalue(sigma_y_k,
                  cons_list(index_multi(site), nil_index_list()),
                  "sigma_y_k")));
          } else {
            current_statement__ = 51;
            lp_accum__.add(
              realprior_lpdf<propto__>(mu[(1 - 1)], prior_hypermean_fam,
                prior_hypermean_val, pstream__));
            current_statement__ = 52;
            lp_accum__.add(
              normal_lpdf<propto__>(y,
                add(
                  add(
                    rvalue(baseline_k,
                      cons_list(index_multi(site), nil_index_list()),
                      "baseline_k"), multiply(mu[(1 - 1)], treatment)), fe),
                rvalue(sigma_y_k,
                  cons_list(index_multi(site), nil_index_list()),
                  "sigma_y_k")));
          }
        }
        current_statement__ = 64;
        lp_accum__.add(
          vecprior_lpdf<propto__>(sigma_y_k, prior_sigma_fam,
            prior_sigma_val, pstream__));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_rubin_full_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> mu_baseline;
      mu_baseline = std::vector<double>(mu_baseline_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= mu_baseline_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(mu_baseline, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu_baseline");}
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<double> tau_baseline;
      tau_baseline = std::vector<double>(tau_baseline_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(tau_baseline, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable tau_baseline");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(tau_baseline, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(tau_baseline[(sym1__ - 1)], 0),
          "assigning variable tau_baseline");}
      std::vector<double> tau;
      tau = std::vector<double>(tau_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable tau");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(tau[(sym1__ - 1)], 0),
          "assigning variable tau");}
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(K_pooled);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      eta = in__.vector(K_pooled);
      Eigen::Matrix<double, -1, 1> eta_baseline;
      eta_baseline = Eigen::Matrix<double, -1, 1>(K_bsl_pooled);
      stan::math::fill(eta_baseline, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      eta_baseline = in__.vector(K_bsl_pooled);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(Nc);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      beta = in__.vector(Nc);
      Eigen::Matrix<double, -1, 1> sigma_y_k;
      sigma_y_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(sigma_y_k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      sigma_y_k = in__.vector(K);
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 8;
        assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_y_k[(sym1__ - 1)], 0),
          "assigning variable sigma_y_k");}
      Eigen::Matrix<double, -1, 1> theta_k;
      theta_k = Eigen::Matrix<double, -1, 1>(K_pooled);
      stan::math::fill(theta_k, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> baseline_k;
      baseline_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(baseline_k, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= mu_baseline_1dim__; ++sym1__) {
        vars__.emplace_back(mu_baseline[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        vars__.emplace_back(tau_baseline[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        vars__.emplace_back(tau[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        vars__.emplace_back(eta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_bsl_pooled; ++sym1__) {
        vars__.emplace_back(eta_baseline[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(sigma_y_k[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 14;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 13;
        assign(theta_k, nil_index_list(), eta, "assigning variable theta_k");
      } else {
        current_statement__ = 12;
        if (logical_eq(pooling_type, 1)) {
          current_statement__ = 11;
          assign(theta_k, nil_index_list(),
            add(rep_vector(mu[(1 - 1)], K_pooled),
              multiply(tau[(1 - 1)], eta)), "assigning variable theta_k");
        } 
      }
      current_statement__ = 19;
      if (logical_eq(pooling_baseline, 0)) {
        current_statement__ = 18;
        assign(baseline_k, nil_index_list(), eta_baseline,
          "assigning variable baseline_k");
      } else {
        current_statement__ = 17;
        if (logical_eq(pooling_baseline, 1)) {
          current_statement__ = 16;
          assign(baseline_k, nil_index_list(),
            add(rep_vector(mu_baseline[(1 - 1)], K),
              multiply(tau_baseline[(1 - 1)], eta_baseline)),
            "assigning variable baseline_k");
        } else {
          current_statement__ = 15;
          assign(baseline_k, nil_index_list(), rep_vector(0.0, K),
            "assigning variable baseline_k");
        }
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
          vars__.emplace_back(theta_k[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          vars__.emplace_back(baseline_k[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<double> logpd;
      logpd = std::vector<double>(logpd_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> fe_test;
      fe_test = Eigen::Matrix<double, -1, 1>(N_test);
      stan::math::fill(fe_test, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 33;
      if (logical_gt(K_test, 0)) {
        current_statement__ = 24;
        if (logical_eq(Nc, 0)) {
          current_statement__ = 23;
          assign(fe_test, nil_index_list(), rep_vector(0.0, N_test),
            "assigning variable fe_test");
        } else {
          current_statement__ = 22;
          assign(fe_test, nil_index_list(), multiply(X_test, beta),
            "assigning variable fe_test");
        }
        current_statement__ = 25;
        assign(logpd, cons_list(index_uni(1), nil_index_list()), 0,
          "assigning variable logpd");
        current_statement__ = 31;
        for (int i = 1; i <= N_test; ++i) {
          current_statement__ = 27;
          if (logical_eq(pooling_type, 1)) {
            current_statement__ = 26;
            assign(logpd, cons_list(index_uni(1), nil_index_list()),
              (logpd[(1 - 1)] +
                normal_lpdf<false>(test_y[(i - 1)],
                  ((baseline_k[(test_site[(i - 1)] - 1)] +
                     (mu[(1 - 1)] * test_treatment[(i - 1)])) +
                    fe_test[(i - 1)]),
                  stan::math::sqrt(
                    (pow(tau[(1 - 1)], 2) +
                      pow(test_sigma_y_k[(test_site[(i - 1)] - 1)], 2))))),
              "assigning variable logpd");
          } 
          current_statement__ = 29;
          if (logical_eq(pooling_type, 2)) {
            current_statement__ = 28;
            assign(logpd, cons_list(index_uni(1), nil_index_list()),
              (logpd[(1 - 1)] +
                normal_lpdf<false>(test_y[(i - 1)],
                  ((baseline_k[(test_site[(i - 1)] - 1)] +
                     (mu[(1 - 1)] * test_treatment[(i - 1)])) +
                    fe_test[(i - 1)]),
                  stan::math::sqrt(
                    pow(test_sigma_y_k[(test_site[(i - 1)] - 1)], 2)))),
              "assigning variable logpd");
          } }
      } 
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        vars__.emplace_back(logpd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        vars__.emplace_back(fe_test[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> mu_baseline;
      mu_baseline = std::vector<double>(mu_baseline_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(mu_baseline, nil_index_list(), context__.vals_r("mu_baseline"),
        "assigning variable mu_baseline");
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(mu, nil_index_list(), context__.vals_r("mu"),
        "assigning variable mu");
      std::vector<double> tau_baseline;
      tau_baseline = std::vector<double>(tau_baseline_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(tau_baseline, nil_index_list(),
        context__.vals_r("tau_baseline"), "assigning variable tau_baseline");
      std::vector<double> tau_baseline_free__;
      tau_baseline_free__ = std::vector<double>(tau_baseline_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(tau_baseline_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(tau_baseline[(sym1__ - 1)], 0),
          "assigning variable tau_baseline_free__");}
      std::vector<double> tau;
      tau = std::vector<double>(tau_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(tau, nil_index_list(), context__.vals_r("tau"),
        "assigning variable tau");
      std::vector<double> tau_free__;
      tau_free__ = std::vector<double>(tau_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(tau_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(tau[(sym1__ - 1)], 0),
          "assigning variable tau_free__");}
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(K_pooled);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 5;
        assign(eta_flat__, nil_index_list(), context__.vals_r("eta"),
          "assigning variable eta_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
          current_statement__ = 5;
          assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
            eta_flat__[(pos__ - 1)], "assigning variable eta");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> eta_baseline;
      eta_baseline = Eigen::Matrix<double, -1, 1>(K_bsl_pooled);
      stan::math::fill(eta_baseline, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eta_baseline_flat__;
        current_statement__ = 6;
        assign(eta_baseline_flat__, nil_index_list(),
          context__.vals_r("eta_baseline"),
          "assigning variable eta_baseline_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= K_bsl_pooled; ++sym1__) {
          current_statement__ = 6;
          assign(eta_baseline,
            cons_list(index_uni(sym1__), nil_index_list()),
            eta_baseline_flat__[(pos__ - 1)],
            "assigning variable eta_baseline");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(Nc);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 7;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 7;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_y_k;
      sigma_y_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(sigma_y_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_y_k_flat__;
        current_statement__ = 8;
        assign(sigma_y_k_flat__, nil_index_list(),
          context__.vals_r("sigma_y_k"),
          "assigning variable sigma_y_k_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 8;
          assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_y_k_flat__[(pos__ - 1)], "assigning variable sigma_y_k");
          current_statement__ = 8;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_y_k_free__;
      sigma_y_k_free__ = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(sigma_y_k_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 8;
        assign(sigma_y_k_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_y_k[(sym1__ - 1)], 0),
          "assigning variable sigma_y_k_free__");}
      for (int sym1__ = 1; sym1__ <= mu_baseline_1dim__; ++sym1__) {
        vars__.emplace_back(mu_baseline[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
        vars__.emplace_back(tau_baseline_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        vars__.emplace_back(tau_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        vars__.emplace_back(eta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_bsl_pooled; ++sym1__) {
        vars__.emplace_back(eta_baseline[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(sigma_y_k_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("mu_baseline");
    names__.emplace_back("mu");
    names__.emplace_back("tau_baseline");
    names__.emplace_back("tau");
    names__.emplace_back("eta");
    names__.emplace_back("eta_baseline");
    names__.emplace_back("beta");
    names__.emplace_back("sigma_y_k");
    names__.emplace_back("theta_k");
    names__.emplace_back("baseline_k");
    names__.emplace_back("logpd");
    names__.emplace_back("fe_test");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(mu_baseline_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(tau_baseline_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tau_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K_pooled)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(K_bsl_pooled)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Nc)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K_pooled)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(logpd_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_test)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= mu_baseline_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_baseline" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_baseline" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K_bsl_pooled; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta_baseline" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_y_k" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "baseline_k" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "fe_test" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= mu_baseline_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_baseline" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_baseline_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_baseline" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K_bsl_pooled; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta_baseline" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_y_k" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "baseline_k" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "fe_test" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu_baseline\",\"type\":{\"name\":\"array\",\"length\":" << mu_baseline_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau_baseline\",\"type\":{\"name\":\"array\",\"length\":" << tau_baseline_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"parameters\"},{\"name\":\"eta_baseline\",\"type\":{\"name\":\"vector\",\"length\":" << K_bsl_pooled << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << Nc << "},\"block\":\"parameters\"},{\"name\":\"sigma_y_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"transformed_parameters\"},{\"name\":\"baseline_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_test\",\"type\":{\"name\":\"vector\",\"length\":" << N_test << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu_baseline\",\"type\":{\"name\":\"array\",\"length\":" << mu_baseline_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau_baseline\",\"type\":{\"name\":\"array\",\"length\":" << tau_baseline_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"parameters\"},{\"name\":\"eta_baseline\",\"type\":{\"name\":\"vector\",\"length\":" << K_bsl_pooled << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << Nc << "},\"block\":\"parameters\"},{\"name\":\"sigma_y_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"transformed_parameters\"},{\"name\":\"baseline_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_test\",\"type\":{\"name\":\"vector\",\"length\":" << N_test << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_rubin_full_namespace::model_rubin_full;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_rubin_full_namespace::profiles__;
}
#endif
#endif
