% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_ma.R
\name{prepare_ma}
\alias{prepare_ma}
\title{Convert from individual to summary data in meta-analyses}
\usage{
prepare_ma(data, log = FALSE, cfb = FALSE, summarise = TRUE,
  treatment = "treatment", baseline = NULL, group = "group",
  outcome = "outcome")
}
\arguments{
\item{data}{data.frame of individual-level observations
with columns for outcome (numeric), treatment (values 0 and 1) and
group (numeric, character or factor);
column names can be user-defined (see below)}

\item{log}{logical; log-transform the outcome variable?}

\item{cfb}{logical; calculate change from baseline? If yes, the outcome
variable is taken as a difference between values in \code{outcome} and
\code{baseline} columns}

\item{summarise}{logical; convert to aggregate level data?}

\item{treatment}{name of column with treatment variable}

\item{baseline}{name of column with baseline variable}

\item{group}{name of the column with grouping variable}

\item{outcome}{name of column with outcome variable}
}
\value{
data.frame with columns \code{mu}, \code{se.mu},
\code{tau} and \code{se.tau}
}
\description{
Allows one-way conversion from full to summary data.
Input must be pre-formatted appropriately.
}
\details{
The conversions done by this function are not typically needed and may happen automatically
when data is fed to \link{baggr}. However, this function can be used to explicitly
convert from full to reduced (summarised) data without analysing it in any model.
It can be useful for examining your data.

If multiple operations are performed, they are taken in this order:
\enumerate{
\item conversion to log scale,
\item calculating change from baseline,
\item summarising data.
}
}
\seealso{
\link{convert_inputs} for how data is converted into Stan inputs;
}
\author{
Witold Wiecek
}
