% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bacon.R
\name{bacon}
\alias{bacon}
\title{Goodman-Bacon Decomposition}
\usage{
bacon(formula, data, id_var, time_var, quietly = F)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic
representation of the model to be fitted. Must be  of the form y ~ D + controls,
where y is the outcome variable,  D is the binary
treatment indicator, and `controls` can be any additional control variables. Do not
include the fixed effects in the formula. If using `.` notation must be of 
the form y ~ D + . - FE1 - FE2}

\item{data}{a data.frame containing the variables in the model.}

\item{id_var}{character, the name of id variable for units.}

\item{time_var}{character, the name of time variable.}

\item{quietly}{logical, default = FALSE, if set to TRUE then bacon() does not
print the summary of estimates/weights by type (e.g. Treated vs Untreated)}
}
\value{
If control variables are included in the formula, then an object of
 class "list" with three elements:
 \item{Omega}{a number between 0 and 1, the weight of the within timing group
  coefficient}
 \item{beta_hat_w}{a number, the within timing group coefficient}
 \item{two_by_twos}{a data.frame with the covariate adjusted 2x2 estimates
  and weights}

If not control variables are included then only the two_by_twos data.frame
 is returned.
}
\description{
bacon() is a function that performs the Goodman-Bacon decomposition for
 differences-in-differences with variation in treatment timing (with or
 without time-varying covariates).
}
\examples{
# Castle Doctrine (Uncontrolled)
df_bacon <- bacon(l_homicide ~ post,
                  data = bacondecomp::castle,
                  id_var = "state",
                  time_var = "year")

# Castle Doctrine (Controlled)
ret_bacon <- bacon(l_homicide ~ post + l_pop + l_income,
                   data = bacondecomp::castle,
                   id_var = "state",
                   time_var = "year")

}
