% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{global}
\alias{global}
\title{Compute global threshold backbone}
\usage{
global(
  G,
  upper = 0,
  lower = NULL,
  keepzeros = TRUE,
  class = "original",
  narrative = FALSE
)
}
\arguments{
\item{G}{A weighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \code{\link{Matrix}}, or dataframe; (2) an edgelist in the form of a three-column dataframe; (3) an \code{\link{igraph}} object.}

\item{upper}{real, FUN, or NULL: upper threshold value or function that evaluates to an upper threshold value.}

\item{lower}{real, FUN, or NULL: lower threshold value or function that evaluates to a lower threshold value.}

\item{keepzeros}{boolean: TRUE if zero-weight edges in \code{W} should be excluded from (i.e. also be zero in) the backbone}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "Matrix", "igraph", "edgelist").
If "original", the backbone graph returned is of the same class as \code{W}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
Binary or signed backbone graph of class given in parameter \code{class}.
}
\description{
\code{global} extracts the backbone of a weighted network using a global threshold
}
\details{
The \code{global} function retains a edge with weight \code{W} if \code{W} > \code{upper}. If a \code{lower} threshold is also
specified, it returns a signed backbone in which an edge's weight is set to 1 if \code{W} > \code{upper},
is set to -1 if \code{W} < \code{lower}, and is set to 0 otherwise. The default is an unsigned backbone containing
all edges with non-zero weights.

If \code{G} is an unweighted bipartite graph, the global threshold is applied to its weighted bipartite projection.
}
\examples{
G <- matrix(sample(0:5, 100, replace = TRUE), 10) #Random weighted graph
diag(G) <- 0
G
global(G, narrative = TRUE)  #Keep all non-zero edges
global(G, upper = 4, lower = 2, narrative = TRUE)  #Signed with specified thresholds
global(G, upper = function(x)mean(x),  #Above-average --> positive edges
          lower = function(x)mean(x), narrative = TRUE)  #Below-average --> negative edges
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

model: {Neal, Z. P. (2014). The backbone of bipartite projections: Inferring relationships from co-authorship, co-sponsorship, co-attendance, and other co-behaviors. \emph{Social Networks, 39}, 84-97. \doi{10.1016/j.socnet.2014.06.001}}
}
