% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb.R
\name{pb}
\alias{pb}
\title{Poisson binomial distribution function}
\usage{
pb(k, p, lowertail = TRUE)
}
\arguments{
\item{k}{numeric: value where the pdf should be evaluated}

\item{p}{vector: vector of success probabilities}

\item{lowertail}{boolean: If TRUE return both upper & lower tail probabilities,
if FALSE return only upper tail probability}
}
\value{
vector, length 2: The first value (if lower = TRUE) is the lower tail probability, the
probability of observing \code{k} or fewer successes when each trial has probability \code{p} of success.
The second value is the upper tail probability, the probability of observing \code{k} or more
successes when each trial has probability \code{p} of success.
}
\description{
\code{pb} computes the poisson binomial distribution function using the refined normal approximation.
}
\details{
The Refined Normal Approximation (RNA) offers a close approximation when \code{length(p)} is
large (Hong, 2013). This function is based on \code{ppoibin()} from the \code{poibin} package.
}
\examples{
pb(50,runif(100))
}
\references{
{Hong, Y. (2013). On computing the distribution function for the Poisson binomial distribution. \emph{Computational Statistics and Data Analysis, 59}, 41-51. \doi{10.1016/j.csda.2012.10.006}}
}
