% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.localdegree}
\alias{sparsify.with.localdegree}
\title{Extract Hamann et al.'s (2016) Local Degree backbone}
\usage{
sparsify.with.localdegree(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \code{\link{Matrix}}; (2) an edgelist in the form of a two-column dataframe; (3) an \code{\link{igraph}} object; (4) a \code{\link{network}} object.}

\item{s}{numeric: Sparsification exponent, 0 < s < 1; smaller values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "sparseMatrix", "igraph", "network", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.localdegree} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the local degree backbone described by Hamann et al. (2016).
It is equivalent to \code{sparsify(escore = "degree", normalize = "rank", filter = "degree", umst = FALSE)}.
}
\examples{
U <- igraph::as.undirected(igraph::sample_pa(60, m = 3), mode = "collapse")
plot(U) #A hairball
sparse <- sparsify.with.localdegree(U, s = 0.3, narrative = TRUE)
plot(sparse) #Clearly visible hubs
}
\references{
{Hamann, M., Lindner, G., Meyerhenke, H., Staudt, C. L., & Wagner, D. (2016). Structure-preserving sparsification methods for social networks. \emph{Social Network Analysis and Mining, 6}, 22. \doi{10.1007/s13278-016-0332-2}}
}
