% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/universal.R
\name{universal}
\alias{universal}
\title{Compute universal threshold backbone}
\usage{
universal(M, upper = 0, lower = NULL, bipartite = FALSE)
}
\arguments{
\item{M}{Matrix: a weighted adjacency matrix or a bipartite adjacency matrix.}

\item{upper}{Real or FUN: upper threshold value or function to be applied to the edge weights. Default is 0.}

\item{lower}{Real or FUN: lower threshold value or function to be applied to the edge weights. Default is NULL.}

\item{bipartite}{Boolean: TRUE if bipartite matrix, FALSE if weighted matrix. Default is FALSE.}
}
\value{
backbone Matrix: Signed (or positive) adjacency matrix of backbone
}
\description{
`universal` returns a unipartite backbone matrix in which
    values are set to 1 if above the given upper parameter threshold,
    and set to -1 if below the given lower parameter threshold, and are 0 otherwise.
}
\examples{
test <- universal(davis\%*\%t(davis), upper = function(x)mean(x)+sd(x), lower=function(x)mean(x))
test2 <- universal(davis, upper = function(x)mean(x)+2*sd(x), lower = 2, bipartite = TRUE)
test3 <- universal(davis, upper = 4, lower = 2, bipartite = TRUE)
}
