% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimRki.R
\name{extendRki}
\alias{extendRki}
\title{extendRki Erweiterung der RKI Daten}
\usage{
extendRki(
  data = getRkiData(babsim.hospital::rkidata),
  EndDate = max(data$Day) + 14,
  R0 = c(1, 1),
  tau = 5
)
}
\arguments{
\item{data}{rki data, e.g., \code{getRkiData(babsim.hospital::rkidata)}}

\item{EndDate}{Ende (Tag), e.g., \code{"2020-05-04"}}

\item{R0}{Basisreproduktionszahl. Constant, if a scalar value is given.
If a vector of two values are given, they will be interpreted as 
a start and an end value, respectively. \code{c(1,2)} defines an increasing
\code{R0} value from \code{1} to \code{2}. Default: \code{1}, i.e., constant \code{1}.
Note: This is NOT exactly the same R0 value presented by the Robert-Koch Institute,
please refer to \url{https://en.wikipedia.org/wiki/Basic_reproduction_number}
for our implementation.}

\item{tau}{Ansteckungszeitraum in Tagen}
}
\description{
Combine existing data with synthetic data
}
\examples{
# take 10,000 data points only:
data <- getRkiData(babsim.hospital::rkidata[1:10000,])
n <-  as.integer( max(data$Day)-min(data$Day) )
StartDay <- min(data$Day) + round(n*0.995)  
data <- data[which(data$Day >=  StartDay), ]
EndDate <- max(data$Day) + 2
dataExt <- extendRki(data = data, 
                     EndDate = EndDate,
                     R0 = c(0.1, 0.2))

}
\seealso{
\code{\link{getRkiData}}
}
